<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-12">
                <h3 class="m-0 text-dark">สินค้า <?php echo e($category->name); ?></h3>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Main row -->
        <div class="row">
            <?php $__currentLoopData = $product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <div class="col-md-4">
                <!-- Default box -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e($p->name); ?></h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 text-center">
                                <img class="card-img-top"
                                    src="<?php echo e(asset('../shopping/storage/app/public/images/'.$p->picture)); ?>" alt="">
                            </div>
                            <div class="col-md-6">
                                <table class="table text-nowrap">
                                    <thead>
                                        <tr>
                                            <th>คงเหลือ</th>
                                            <th>หน่วย</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php
                                        $stock = App\Stock::with('unit')
                                        ->select('unit_id', DB::raw('SUM(total) as total_all'))
                                        ->groupBy('unit_id')
                                        ->where('product_id', $p->id)->get();
                                        ?>

                                        <?php $__currentLoopData = $stock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php echo e($s->total_all); ?>

                                            </td>
                                            <td>
                                                <?php echo e($s->unit->name); ?>

                                            </td>

                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <button type="button" class="btn btn-success btn-sm mt-3"
                                    onclick="go2add('<?php echo e($p->id); ?>')">นำเข้าสินค้า</button>

                                <button type="button" class="btn btn-primary btn-sm mt-3"
                                    onclick="go2detail('<?php echo e($p->id); ?>')">รายละเอียด</button>
                            </div>
                        </div>
                        
                    </div>

                </div>
                <!-- /.card -->
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
        <br>
        <?php echo e($product->links()); ?>

        <!-- /.row (main row) -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('footerscript'); ?>

<script>
    function go2add(id){
    // alert(id);
    var url = '<?php echo e(route('stock.addStock',['product_id'=>':id'])); ?>';
        url = url.replace(':id',id);
        // alert(url);

        window.location.replace(url);
    }
</script>

<script>
    function go2detail(id){
        // alert(id);
        var url = '<?php echo e(route('stock.stockDetail',['product_id'=>':id'])); ?>';
            url = url.replace(':id',id);
            // alert(url);

            window.location.replace(url);
        }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cp266440/public_html/store.richendless.co.th/shopping/resources/views/backend/stock/category.blade.php ENDPATH**/ ?>