<?php $__env->startSection('content'); ?>

<div class="card mx-1 my-2">
    <div class="card-header">
        <h3 class="card-title">แก้ไขสินค้า -> <?php echo e($product->name); ?> </h3>
    </div>

    <div class="card-body">

        <?php echo Form::model($product, ['novalidate','route' => ['product.update',$product->id], 'method' => 'put', 'files'
        => true,'class'=> ($errors->any()) ? 'was-validated' : 'needs-validation']); ?>

        

        <div class="form-group">
            <label for="exampleFormControlInput1">ชื่อสินค้า</label> <?php echo e(Form::text('name', null,['class'=>'form-control ',
                    'required'])); ?>

            <?php if($errors->has('name')): ?>
            <div class="invalid-feedback"><?php echo e($errors->first('name')); ?></div>
            <?php endif; ?>
        </div>

        

        <div class="form-group">
            <label for="exampleFormControlSelect1">เลือกประเภทสินค้า</label>
            <?php echo e(Form::select('category_id', App\Category::all()->pluck('name',
                    'id'), null, ['class' => 'selectpicker form-control', 'placeholder' => 'กรุณาเลือกประเภทสินค้า...', 'required','data-live-search="true"'])); ?>

            <?php if($errors->has('category_id')): ?>
            <div class="invalid-feedback"><?php echo e($errors->first('category_id')); ?></div>
            <?php endif; ?>
        </div>

        <div class="form-group">
            <img src="<?php echo e(asset('../shopping/storage/app/public/images/'.$product->picture)); ?>" width="200">
        </div>

        <div class="custom-file">
            <input name="picture" type="file" class="custom-file-input" id="customFile"
                <?php echo e($errors->has('picture') ? ' required' : ' '); ?>>
            <label class="custom-file-label" for="customFile">แก้ไขรูปภาพใหม่</label>
            <?php if($errors->has('picture')): ?>
            <?php $__currentLoopData = $errors->get('picture'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

        </div>


        <button type="submit" class="btn btn-primary mt-3">บันทึก</button>

        </form>


    </div>
    <!-- /.card-body -->
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('footerscript'); ?>

<!-- Latest compiled and minified CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/css/bootstrap-select.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/js/bootstrap-select.min.js"></script>

<script>
    $('select').selectpicker();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cp266440/public_html/store.richendless.co.th/store/resources/views/backend/product/edit.blade.php ENDPATH**/ ?>