<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h3>ออเดอร์ของฉัน</h3>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">วันที่</th>
                                <th scope="col">ชื่อผู้รับ</th>
                                <th scope="col">รายการสินค้า</th>
                                <th scope="col">ยอดเงิน(บาท)</th>
                                <th scope="col">สถานะ</th>
                                <th scope="col">เครื่องมือ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $listOrder; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                                <td>
                                    <?php if($o->created_at != ""): ?>
                                    <?php $__currentLoopData = explode(' ', $o->created_at); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($loop->first): ?>
                                    <?php echo e($date); ?>

                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($o->address->name); ?></td>
                                <td>
                                    <?php
                                        $i = 0;
                                    ?>
                                    <?php if($o->detail != ""): ?>
                                    <?php $__currentLoopData = explode('|', $o->detail); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                    $product_Detail = explode(":",$product);
                                    $product_Name = $product_Detail[0];
                                    $product_Qty = $product_Detail[1];
                                    $product_Price = $product_Detail[2];
                                    $product_Total = $product_Detail[3];
                                    ?>
                                    <a href="<?php echo e('#'); ?>" rel="tooltip" title="<?php echo e($product_Name); ?>">
                                        <?php echo e(str_limit($product_Name,35)); ?></a><br>
                                    <span style="font-size:80%"><?php echo e($product_Qty); ?> หน่วย ราคา/หน่วย <?php echo e($product_Price); ?> รวม <?php echo e(number_format($product_Total,2)); ?> บาท</span> <br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(number_format($o->total,2)); ?></td>
                                <td>
                                    <?php if($o->invoice_id=='1'): ?>
                                    กำลังดำเนินการ
                                    <?php else: ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <form method="POST" action="<?php echo e(route('order.destroy',['id'=>$o->id])); ?>"
                                        class="d-inline" onsubmit="return confirm('คุณต้องการลบข้อมูลใช่ หรือไม่?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-danger btn-sm">
                                            ยกเลิก
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <br>
                </div>
            </div>
        </div>


    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerscript'); ?>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","success");
</script>
<?php endif; ?>

<script type="text/javascript">
	$(document).ready(function(){
	    $("[rel=tooltip]").tooltip({ placement: 'top'});
	});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/shopping/resources/views/order/index.blade.php ENDPATH**/ ?>