<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h3>ที่อยู่ของฉัน <a href="<?php echo e(route ('address.create')); ?>" style="font-size:50%">เพิ่มที่อยู่</a>
                    </h3>
                </div>
                <div class="card-body" style="overflow-x: auto;">

                    

                    <table class="table text-nowrap" id="address-table">
                        <thead>
                            <tr>
                                <th scope="col">ชื่อ</th>
                                <th scope="col">ที่อยู่</th>
                                <th scope="col" width="1px">ตำบล/แขวง</th>
                                <th scope="col" width="1px">อำเภอ/เขต</th>
                                <th scope="col" width="1px">จังหวัด</th>
                                <th scope="col" width="1px">รหัสไปรษณีย์</th>
                                <th scope="col">โทร</th>
                                <th scope="col">เครื่องมือ</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>


    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerscript'); ?>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","success");
</script>
<?php endif; ?>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js"></script>

<script>
    var table = $('#address-table').DataTable({
    serverSide: true,
    ajax: "<?php echo e(route('address.getAddressAjax')); ?>",
    columns: [
        { name: 'name' },
        { name: 'address'},
        { name:'sub_district',"visible": false},
        { name:'district',"visible": false},
        { name:'province',"visible": false},
        { name:'zipcode',"visible": false},
        { name:'tel'},
        // { name: 'category.name', orderable: false },
        { name: 'action', orderable: false, searchable: false }
    ],
});

$('#address-table').on('click','#btnDel',function(e){
    var tr = $(this).closest('tr');
    var row = table.row(tr);

    var id = row.data().DT_RowData.id;
    //alert(id);

    e.preventDefault();

    var url = '<?php echo e(route('address.destroy',['id'=>':id'])); ?>';
    url = url.replace(':id',id);
    //alert(url);

    $('#frmDel').attr('action',url).submit();

});


$('#address-table').on('click','#btnEdit',function(e){
    var tr = $(this).closest('tr');
    var row = table.row(tr);

    var id = row.data().DT_RowData.id;
    //alert(id);

    e.preventDefault();

    var url = '<?php echo e(route('address.edit',['id'=>':id'])); ?>';
    url = url.replace(':id',id);
    //alert(url);

    window.location.replace(url);

});

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/shopping/resources/views/address/index.blade.php ENDPATH**/ ?>