<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Dashboard <?php echo e(config('app.name')); ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">

</head>

<body class="hold-transition sidebar-mini">
    <div id="app" class="wrapper">

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand bg-white navbar-light border-bottom">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#"><i class="fa fa-bars"></i></a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a href="<?php echo e(route('dashboard')); ?>" class="nav-link">หน้าหลัก</a>
                </li>
                <li class="nav-item d-sm-inline-block text-nowrap">
                    <a href="<?php echo e(route('welcome')); ?>" class="nav-link">ซื้อสินค้า</a>
                </li>
                <li class="nav-item d-sm-inline-block">
                    <a href="<?php echo e(route('stock.index')); ?>" class="nav-link">Stock</a>
                </li>
            </ul>
            <!-- Right navbar links -->
            <ul class="navbar-nav ml-auto">
                <li class="nav-item d-sm-inline-block bg-warning">
                    <a class="nav-link" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                              document.getElementById('logout-form').submit();">
                        ออกจากระบบ
                    </a>

                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                    </form>
                </li>
            </ul>

        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="<?php echo e(route('dashboard')); ?>" class="brand-link">
                <img src="<?php echo e(asset('img/logo.png')); ?>" alt="Logo" class="brand-image img-circle elevation-3"
                    style="opacity: .8">
                <span class="brand-text font-weight-light"><?php echo e(config('app.name')); ?></span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar user panel (optional) -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        
                    </div>
                    <div class="info">
                        <a href="#" class="d-block">Hello, <?php echo e(auth()->user()->name); ?></a>
                        <small class="text-light">
                            ที่อยู่ : <?php echo e(optional(auth()->user()->profile)->address); ?>

                        </small>
                        <br>
                        <small class="text-light">
                            อีเมล์ : <?php echo e(auth()->user()->email); ?>

                            <br>
                            บทบาท : <?php echo e(auth()->user()->getRoleNames()[0]); ?>

                            
                        </small>
                    </div>
                </div>

                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">

                        <li class="nav-header">ข้อมูลหลัก</li>

                        <?php if(auth()->check() && auth()->user()->hasRole('Admin')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('category.index')); ?>" class="nav-link">
                                <i class="nav-icon fa fa-th-large"></i>
                                <span class="brand-text font-weight-light"
                                    style="display: inline-block">ประเภทสินค้า</span>
                            </a>
                        </li>

                        
                        
                        <?php endif; ?>

                        

                        <li class="nav-item has-treeview">
                            <a href="<?php echo e(route('product.index2')); ?>" class="nav-link">
                                <i class="nav-icon fa fa-cubes"></i>
                                <span class="brand-text font-weight-light">สินค้า</span>
                            </a>
                        </li>

                        <li class="nav-item has-treeview">
                            <a href="<?php echo e(route('price.index')); ?>" class="nav-link">
                                <i class="nav-icon fa fa-table"></i>
                                <span class="brand-text font-weight-light">ราคาสินค้า</span>
                            </a>
                        </li>

                        <li class="nav-item has-treeview">
                            <a href="<?php echo e(route('myorder.confirmed')); ?>" class="nav-link">
                                <i class="nav-icon fa fa-check-square-o"></i>
                                <span class="brand-text font-weight-light">คำสั่งซื้อที่ยืนยันแล้ว</span>
                            </a>
                        </li>


                        

                    </ul>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <!-- /.content-wrapper -->
        <footer class="main-footer">
            <strong>Copyright &copy; <?php echo e(date('Y')); ?> <a href="http://adminlte.io">AdminLTE.io</a>.</strong> All rights
            reserved.
            <div class="float-right d-none d-sm-inline-block">
                <b>Version</b> 1.0
        </footer>

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->
    </div>
    <!-- ./wrapper -->

    
    <?php echo $__env->make('partials.showproduct', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('../shopping/node_modules/moment/moment.js')); ?>"></script>
    <script src="<?php echo e(asset('../shopping/node_modules/chart.js/dist/Chart.js')); ?>"></script>

    <?php echo $__env->yieldContent('footerscript'); ?>

</body>

</html>
<?php /**PATH /home/cp266440/public_html/store.richendless.co.th/store/resources/views/layouts/backend.blade.php ENDPATH**/ ?>