<?php $__env->startSection('content'); ?>

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h2 class="m-0 text-dark">ออกใบกำกับภาษี (Invoice)</h2>
            </div>
            <!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">ออกใบกำกับภาษี</li>
                </ol>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>

<!-- Main content -->
<section class="content">

    <div class="row">
        <div class="col-lg-6 col-md-6 mb-4">
            <div id="accordion">
                <div class="card" id="card_address">
                    <div class="card-header" id="headingAddress">
                        <h5 class="mb-0">
                            <button type="button" class="btn btn-link" data-toggle="collapse" data-target="#collapseOne"
                                aria-expanded="true" aria-controls="collapseOne">
                                <h5>ข้อมูลที่อยู่</h5>
                            </button>
                            <ol class="float-sm-right">
                                <button type="button" class="btn btn-success" hidden='true' id="btn-e-address"
                                    onclick="update_address()">อัพเดท</button>
                            </ol>
                        </h5>
                    </div>

                    <div id="collapseOne" class="collapse show" aria-labelledby="headingAddress"
                        data-parent="#accordion">
                        <div class="card-body">

                            <div class="form-group">
                                <label for="exampleFormControlInput1">ชื่อ</label> <?php echo e(Form::text('name', $address->name,['class'=>'form-control ',
                                                'required', 'id' => 'name','onchange' => 'highlight_box(this.id)'
                                                ,'autocomplete'=>'off'])); ?>

                                <?php if($errors->has('name')): ?>
                                <div class="invalid-feedback"><?php echo e($errors->first('name')); ?></div>
                                <?php endif; ?>
                            </div>

                            <div class="form-group">
                                <label for="exampleFormControlInput1">ที่อยู่</label>
                                <?php echo e(Form::text('address', $address->address,['class'=>'form-control ',
                                                    'required', 'id' => 'address','onchange' => 'highlight_box(this.id)'
                                                    ,'autocomplete'=>'off'])); ?>

                                <?php if($errors->has('address')): ?>
                                <div class="invalid-feedback"><?php echo e($errors->first('address')); ?></div>
                                <?php endif; ?>
                            </div>

                            <div class="form-inline">
                                <div class="form-group mr-2 mb-4">
                                    <div class="form-group">
                                        <label for="exampleFormControlSelect1">จังหวัด : </label>
                                        <?php echo e(Form::select('province', $province->pluck('name_th','name_th'), $address->province,
                                            ['class' => 'form-control dynamic', 'placeholder' => 'เลือกจังหวัด...', 'required'
                                                        , 'data-dependent' => 'districts' , 'id' => 'province'
                                                        ,'onchange' => 'highlight_box(this.id)'])); ?>

                                        <?php if($errors->has('province')): ?>
                                        <div class="invalid-feedback"><?php echo e($errors->first('province')); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="form-group mr-2 mb-4">
                                    <div class="form-group">
                                        <label for="exampleFormControlInput1">อำเภอ/เขต : </label> <?php echo e(Form::text('district', $address->district,['class'=>'form-control ',
                                            'placeholder' => 'อำเภอ/เขต...','required', 'id' => 'district'
                                            ,'onchange' => 'highlight_box(this.id)','autocomplete'=>'off'])); ?>

                                        <?php if($errors->has('district')): ?>
                                        <div class="invalid-feedback"><?php echo e($errors->first('district')); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="form-group mr-2 mb-4">
                                    <div class="form-group">
                                        <label for="exampleFormControlInput1">ตำบล/แขวง : </label> <?php echo e(Form::text('sub_district', $address->sub_district,['class'=>'form-control ',
                                                'placeholder' => 'ตำบล/แขวง...','required', 'id' => 'sub_district'
                                                ,'onchange' => 'highlight_box(this.id)','autocomplete'=>'off'])); ?>

                                        <?php if($errors->has('sub_district')): ?>
                                        <div class="invalid-feedback"><?php echo e($errors->first('sub_district')); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                            </div>

                            <div class="form-inline">

                                <div class="form-group mr-2">
                                    <label for="exampleFormControlInput1">รหัสไปรษณีย์ :</label>
                                    <?php echo e(Form::text('zipcode', $address->zipcode,['class'=>'form-control ',
                                                        'placeholder' => 'รหัสไปรษณีย์...','required', 'id' => 'zipcode'
                                                        ,'onchange' => 'highlight_box(this.id)','autocomplete'=>'off'])); ?>

                                    <?php if($errors->has('zipcode')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('zipcode')); ?></div>
                                    <?php endif; ?>
                                </div>

                                <div class="form-group">
                                    <label for="exampleFormControlInput1">โทร :</label>
                                    <?php echo e(Form::text('tel', $address->tel,['class'=>'form-control ',
                                                        'placeholder' => 'โทร...','required', 'id' => 'tel'
                                                        ,'onchange' => 'highlight_box(this.id)','autocomplete'=>'off'])); ?>

                                    <?php if($errors->has('tel')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('tel')); ?></div>
                                    <?php endif; ?>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6 col-md-6 mb-4">
            <div id="accordion2">
                <div class="card">
                    <div class="card-header" id="headingDocIV">
                        <h5 class="mb-0">
                            <button type="button" class="btn btn-link" data-toggle="collapse"
                                data-target="#collapseThree" aria-expanded="true" aria-controls="collapseThree">
                                <h5>ข้อมูลเอกสาร</h5>
                            </button>
                            <ol class="float-sm-right">
                                <button type="button" class="btn btn-success" hidden='true' id="btn-e-addressD"
                                    onclick="validateAddr()">อัพเดท</button>
                            </ol>
                        </h5>
                    </div>
                    <div id="collapseThree" class="collapse show" aria-labelledby="headingDocIV"
                        data-parent="#accordion2">
                        <div class="card-body" id="testIV">
                            <div class="form-inline">
                                <div class="form-group mr-2">
                                    <label for="exampleFormControlInput1">เลขที่เอกสาร :</label>
                                    <?php echo e(Form::text('iv_num', $invoice['iv_num'],['class'=>'form-control DaddrDefault',
                                                                'placeholder' => 'เลขที่เอกสาร...','required', 'id' => 'iv_num'
                                                                ,'onchange' => 'highlight_box_address(this.id)','autocomplete'=>'off'])); ?>

                                    <?php if($errors->has('iv_num')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('iv_num')); ?></div>
                                    <?php endif; ?>
                                </div>

                                <div class="form-group">
                                    <label for="exampleFormControlInput1">วันที่ :</label>
                                    <?php echo e(Form::date('iv_date', $invoice['date'],['class'=>'form-control DaddrDefault',
                                                                'placeholder' => 'วันที่...','required', 'id' => 'iv_date'
                                                                ,'onchange' => 'highlight_box_address(this.id)','autocomplete'=>'off'])); ?>

                                    <?php if($errors->has('iv_date')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('iv_date')); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="form-inline mt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlSelect1">พนักงานขาย : </label>
                                    <?php echo e(Form::select('sale', $user->pluck('fullname','id'), $myorder->user_id,
                                            ['class' => 'form-control DaddrDefault', 'placeholder' => 'พนักงานขาย...', 'required'
                                                        , 'data-dependent' => 'districts' , 'id' => 'sale'
                                                        ,'onchange' => 'highlight_box_address(this.id)'])); ?>

                                    <?php if($errors->has('sale')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('sale')); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <hr>
                            <?php
                            if($address->s_detail=='Y'){
                            $a_tax_num = $address->tax_num;
                            $a_top = $address->t_o_p;
                            $a_logistic = $address->logistic;
                            $a_detail = '';
                            }else{
                            $a_detail = '(ยังไม่มีข้อมูล)';
                            $a_tax_num = null;
                            $a_top = null;
                            $a_logistic = null;
                            }
                            ?>
                            <h5>ข้อมูลลูกค้า <span style="color:red" id="NoAddrD"><?php echo e($a_detail); ?></span></h5>
                            <div class="form-inline mt-3">
                                <div class="form-group mr-2">
                                    <label for="exampleFormControlInput1">รหัสลูกค้า :</label>
                                    <?php echo e(Form::text('customer_code', 'DSC'.$invoice['customer_code'],['class'=>'form-control DaddrDefault',
                                                                    'placeholder' => 'เลขที่เอกสาร...','required', 'id' => 'customer_code'
                                                                    ,'onchange' => 'highlight_box_address(this.id)','autocomplete'=>'off'])); ?>

                                    <?php if($errors->has('customer_code')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('customer_code')); ?></div>
                                    <?php endif; ?>
                                </div>
                                <div class="form-group">
                                    <label for="exampleFormControlInput1">เลขที่ภาษี :</label>
                                    <?php echo e(Form::text('tax_num', $a_tax_num,['class'=>'form-control DaddrDefault','size' => '20',
                                                                    'placeholder' => 'เลขที่ภาษี','required', 'id' => 'tax_num'
                                                                    ,'onchange' => 'highlight_box_address(this.id)','autocomplete'=>'off'])); ?>

                                    <?php if($errors->has('tax_num')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('tax_num')); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="form-inline mt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1">การชำระเงิน :</label>
                                    <?php echo e(Form::number('ToP', $a_top,['class'=>'form-control DaddrDefault','min' => '0','max' => '999',
                                                                    'placeholder' => '-','required', 'id' => 'ToP'
                                                                    ,'onchange' => 'highlight_box_address(this.id)','autocomplete'=>'off'])); ?>

                                    <label for="exampleFormControlInput1">วัน</label>
                                    <?php if($errors->has('ToP')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('ToP')); ?></div>
                                    <?php endif; ?>
                                </div>
                                

                                <div class="form-group ml-2">
                                    <label for="exampleFormControlSelect1">การขนส่ง : </label>
                                    <?php echo e(Form::select('Logistic', $logistic->pluck('name','name'), $a_logistic,
                                        ['class' => 'form-control DaddrDefault', 'placeholder' => 'เลือกการขนส่ง', 'required'
                                                    , 'data-dependent' => 'districts' , 'id' => 'Logistic'
                                                    ,'onchange' => 'highlight_box_address(this.id)'])); ?>

                                    <?php if($errors->has('Logistic')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('Logistic')); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card" style="overflow-x:auto;">
        <div class="card-header" id="headingMyorder">
            <h2 class="card-title">รายการสินค้า <span style="color:red">(ห้ามเปลี่ยนชื่อสินค้าเป็นสินค้าคนละชนิด)</span></h2>

            <ol class="float-sm-right">
                <button type="button" class="btn btn-success" hidden='true' id="btn-e-myorder"
                    onclick="validateMO()">อัพเดท</button>
            </ol>
        </div>


        <?php echo Form::open(['novalidate','route' => 'product.store', 'method' => 'post', 'files' => true,'class'=>
        ($errors->any()) ? 'was-validated' : 'needs-validation']); ?>

        <div class="card-body">

            <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <?php endif; ?>

            <table class="table table-hover shopping-cart-wrap text-nowrap">
                <thead class="text-muted">
                    <tr>
                        <th>ลำดับ</th>
                        <th scope="col">รายการสินค้า</th>
                        <th scope="col">จำนวน</th>
                        <th scope="col">หน่วย</th>
                        <th scope="col">ราคาต่อหน่วย</th>
                        <th scope="col">ราคารวม</th>
                        <th scope="col" class="text-right"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $listOrder; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indexKey => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <p><?php echo e(++$indexKey); ?></p>
                        </td>
                        <td>
                            <input id="list_<?php echo e($order->id); ?>" name="list[]" type="text" size="60"
                                value="<?php echo e($order->product_name); ?>" onchange="highlight_box_order(this.id)"
                                class="gDefault"><br>
                            <?php
                            if($order->show_list == '1'){
                            $show = '';
                            }else{
                            $show = 'checked';
                            }
                            ?>

                            <div class="form-check mt-2" style="color:red">
                                <input class="form-check-input" type="checkbox" value="<?php echo e($order->show_list); ?>"
                                    id="show_<?php echo e($order->id); ?>" <?php echo e($show); ?> onchange="highlight_box_order(this.id)">
                                <label class="form-check-label" for="show_<?php echo e($order->id); ?>">
                                    ไม่แสดงข้อมูล ในใบกำกับภาษี
                                </label>
                            </div>

                        </td>

                        <td>
                            <input id="qty_<?php echo e($order->id); ?>" name="qty[]" type="number" min="0" max="10000" step="1"
                                value="<?php echo e($order->qty); ?>" onchange="highlight_box_order(this.id),
                                cal_total(<?php echo e($order->id); ?>)" class="gDefault" />
                        </td>

                        <td>
                            <input id="unit_<?php echo e($order->id); ?>" name="unit[]" type="text" size="10"
                                value="<?php echo e($order->unit_name); ?>" onchange="highlight_box_order(this.id)"
                                class="gDefault" />
                        </td>
                        <td>
                            <input id="peru_<?php echo e($order->id); ?>" name="peru[]" type="number" min="0" step="1"
                                value="<?php echo e($order->price_now); ?>" onchange="highlight_box_order(this.id),
                                cal_total(<?php echo e($order->id); ?>)" class="gDefault" />
                        </td>
                        <td>
                            <p id="total_<?php echo e($order->id); ?>" name="total[]" onchange="highlight_box_order(this.id)"
                                class="gDefault"><?php echo e($order->total); ?></p>
                        </td>
                        <td>
                            <input name="MO_id[]" type="number" min="0" step="1" value="<?php echo e($order->id); ?>"
                                hidden='true' />
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <tr class="table-active">
                        <td></td>
                        <td></td>
                        
                        <td><input id="checkAddress" type="text" value="T" hidden='true' /></td>
                        <td><input id="checkDaddress" type="text" value="T" hidden='true' /></td>
                        <td><input id="checkTF" type="text" value="T" hidden='true' /></td>
                        <td>
                            <span id="Tsum" style="font-size:150%">0</span>
                        </td>
                        <td><span>บาท</span></td>
                    </tr>
                </tbody>
            </table>

            

    </div>
    <!-- /.card-body -->
    </div>

    <div class="text-center">
        
        <button type="button" class="btn btn-lg btn-success mb-3" id="btn-submit" >ยืนยัน/บันทึก</button>
    </div>

    </form>
</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerscript'); ?>
<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>
<script src="<?php echo e(asset('../resources/views/backend/invoice/js/FnOnchange.js')); ?>"></script>
<script>
    $.ajaxSetup({
    headers: {
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
    }
});

$("#btn-e-address").click(function(e) {

var _token = $('input[name="_token"]').val();
var a_name = $('input[id="name"]').val();
var a_address = $('input[id="address"]').val();
var a_province = $("#province").val();
var a_district = $('input[id="district"]').val();
var a_sub_district = $('input[id="sub_district"]').val();
var a_zipcode = $('input[id="zipcode"]').val();
var a_tel = $('input[id="tel"]').val();
var address_id = "<?php echo e($address->id); ?>";

e.preventDefault();
$.ajax({
    url:"<?php echo e(route('invoice.e_address')); ?>",
    method:"POST",
    data:{a_name:a_name,a_address:a_address,a_province:a_province
        ,a_district:a_district,a_sub_district:a_sub_district,a_zipcode:a_zipcode
        ,a_tel:a_tel, _token:_token,address_id:address_id},
    success:function(result)
    {
        //$("#testIV").html(result);
        if(result!="success"){
        swal(result, "( ข้อมูลที่อยู่ )", "error");
        }else{
        swal("Good job!", "You clicked the button!", "success");
        }
    }
})
});

$("#btn-e-myorder").click(function(e) {

    var checkTF = document.getElementById('checkTF').value;
    if(checkTF == 'T'){
    var RMO_id = document.getElementsByName("MO_id[]");
        for (var i = 0; i < RMO_id.length; i++) {
            var order_id = RMO_id[i].value;
            var list = document.getElementById("list_" + RMO_id[i].value).value;
            var qty = document.getElementById("qty_" + RMO_id[i].value).value;
            var unit = document.getElementById("unit_" + RMO_id[i].value).value;
            var peru = document.getElementById("peru_" + RMO_id[i].value).value;
            var _token = $('input[name="_token"]').val();

            var Tsum = document.getElementById("Tsum").innerHTML;
            var totalT = parseFloat(Tsum.replace(/,/g, ''));

            var a_name = $('input[id="name"]').val();

            var show = '1';
            var show_list = document.getElementById("show_" + RMO_id[i].value);
            if(show_list.checked == true){
                show = '0';
            }

            runAjax(order_id);
        }
    }else{
        swal('กรุณาตรวจสอบข้อมูล', "( รายการสินค้า )", "error");
    }
    function runAjax(id) {
            $.ajax({
                url:"<?php echo e(route('invoice.e_myorder')); ?>",
                method:"POST",
                data:{order_id:id,list:list,qty:qty,unit:unit,peru:peru, _token:_token,
                    totalT:totalT,a_name:a_name,show:show},
                success:function(result)
                {
                    //$("#testIV").html(result);
                    if(result!="success"){
                    swal(result, "( ข้อมูลที่อยู่ )", "error");
                    }else{
                    swal("Good job!", "You clicked the button!", "success");
                    }
                }
            });
    }
});

$("#btn-e-addressD").click(function(e) {

var checkDaddress = document.getElementById('checkDaddress').value;
if(checkDaddress == 'T'){

    var address_id = "<?php echo e($address->id); ?>";
    var tax_num = document.getElementById("tax_num").value;
    var ToP = document.getElementById("ToP").value;
    var Logistic = document.getElementById("Logistic").value;
    var _token = $('input[name="_token"]').val();

    runAjaxAD(address_id);

}else{
    swal('กรุณาตรวจสอบข้อมูล', "( รายการสินค้า )", "error");
}
function runAjaxAD(id) {
        $.ajax({
            url:"<?php echo e(route('invoice.e_addressD')); ?>",
            method:"POST",
            data:{address_id:id,tax_num:tax_num,_token:_token,
                ToP:ToP,Logistic:Logistic},
            success:function(result)
            {
                //$("#testIV").html(result);
                if(result!="success"){
                swal(result, "( ข้อมูลลูกค้า )", "error");
                }else{
                swal("Good job!", "You clicked the button!", "success");
                }
            }
        });
}
});

$("#btn-submit").click(function(e) {

validateAddr();

var checkAddress = document.getElementById('checkAddress').value;
var checkDaddress = document.getElementById('checkDaddress').value;
var checkTF = document.getElementById('checkTF').value;

if(checkAddress == 'T' && checkDaddress == 'T' && checkTF == 'T'){

    var _token = $('input[name="_token"]').val();

    var myorder_id = "<?php echo e($myorder_id); ?>";
    var iv_num = document.getElementById("iv_num").value;
    var iv_date = document.getElementById("iv_date").value;
    var sale = document.getElementById("sale").value;


    runAjaxSave(myorder_id);

}else{
    swal('กรุณาตรวจสอบข้อมูล', "( รายการสินค้า )", "error");
}
function runAjaxSave(id) {
        $.ajax({
            url:"<?php echo e(route('invoice.saveIV')); ?>",
            method:"POST",
            data:{myorder_id:id,iv_num:iv_num,iv_date:iv_date,
                sale_id:sale,_token:_token},
            success:function(result)
            {
                //$("#testIV").html(result);
                if(result!="success"){
                swal(result, "", "error");
                }else{
                swal("Good job!", "You clicked the button!", "success");
                }
            }
        });
}
});
</script>
<script>
    sum_total();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/shopping/resources/views/backend/invoice/create.blade.php ENDPATH**/ ?>