<?php $__env->startSection('content'); ?>

<div class="card mx-1 my-2">
    <div class="card-header">
    <h3 class="card-title">แก้ไขหน่วยสินค้า</h3>
    </div>

    <div class="card-body">

            <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <?php endif; ?>

            <?php echo Form::open(['novalidate','route' => 'stock.unit_update', 'method' => 'post', 'files' => true,'class'=>
            ($errors->any()) ? 'was-validated' : 'needs-validation']); ?>

            

            <div class="form-group">
                <label for="exampleFormControlInput1">หน่วย (Unit)</label> <?php echo e(Form::text('name', $unit_number->name,['class'=>'form-control ',
                        'autocomplete'=>'off','required'])); ?>

                <?php if($errors->has('name')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('name')); ?></div>
                <?php endif; ?>
            </div>
            <?php
            $unit = App\Unit::where('product_id', $product_id)->get();

            ?>
            <div class="form-group">
                <label>จำนวนต่อหน่วย</label> <?php echo e(Form::number('per_parent', $unit_number->per_parent,['class'=>'form-control ', 'placeholder' => 'จำนวน...'
                            ,'autocomplete' => 'off','required'])); ?>

                <?php if($errors->has('per_parent')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('per_parent')); ?></div>
                <?php endif; ?>
            </div>

            <?php
            $unit_p = App\Unit::where('product_id', $product_id)->where('id', '!=' , $unit_number->id)->get();
            ?>

            <?php if($unit_number->parent_id != 0): ?>
            <div class="form-group">
                <label>หน่วย</label>
                <?php echo e(Form::select('parent_id', $unit_p->pluck('name','id'),
                $unit_number->parent_id, ['class' => 'form-control dynamic', 'placeholder' => 'กรุณาเลือกหน่วย...',
                'required','id'=>'SelAddress','onchange'=>'testS(this.value)'])); ?>

                <?php if($errors->has('parent_id')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('parent_id')); ?></div>
                <?php endif; ?>
            </div>

            <?php else: ?>
            <div class="form-group">
                <label>หน่วย</label>
                <?php echo e(Form::select('parent_id', array('0' => '-'), '0'
                , ['class' => 'form-control dynamic',
                'required','id'=>'SelAddress','onchange'=>'testS(this.value)'])); ?>

                <?php if($errors->has('parent_id')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('parent_id')); ?></div>
                <?php endif; ?>
            </div>

            <?php endif; ?>

            <input type="text" name="unit_id" value="<?php echo e($unit_number->id); ?>" hidden>
            <input type="text" name="product_id" value="<?php echo e($product_id); ?>" hidden>

            <button type="submit" class="btn btn-primary mt-3">แก้ไข</button>

            <span class="ml-2">
                <a href="<?php echo e(route('stock.addStock',['product_id'=>$product_id])); ?>" class="btn btn-secondary mt-3">
                    <i class="fa fa-chevron-circle-left text-white"> Back กลับ</i>
                </a>
            </span>

            </form>

        </div>
    <!-- /.card-body -->
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footerscript'); ?>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","error");
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/shopping/resources/views/backend/stock/unit/edit.blade.php ENDPATH**/ ?>