<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-12">
                <h3 class="m-0 text-dark">นำเข้าสินค้า <br><span
                        style="color:blue;font-size:80%"><?php echo e($product->name); ?></span></h3>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <form novalidate class="<?php echo e(($errors->any()) ? 'was-validated' : 'needs-validation'); ?>" method="post"
            enctype="multipart/form-data" action="<?php echo e(route('stock.store')); ?>">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">หน่วยสินค้า
                                <span class="ml-2">
                                    <?php if(count($unit)<1): ?> <a
                                        href="<?php echo e(route('stock.unit_create',['product_id'=>$product->id])); ?>"
                                        class="btn btn-success btn-sm mb-1">
                                        <i class="fa fa-plus-circle text-white"> เพิ่ม</i>
                                        </a>
                                        <?php else: ?>
                                        <?php endif; ?>

                                </span>
                            </h3>

                        </div>
                        <div class="card-body" style="overflow-x: auto;">

                            <?php if(count($unit)>0): ?>
                            <table class="table text-nowrap">
                                <thead>
                                    <tr>
                                        <th scope="col">หน่วย</th>
                                        <th scope="col">จำนวน</th>
                                        <th scope="col">ต่อ</th>
                                        <th scope="col"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $unit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indexKey => $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                    if($u->parent_id != 0){
                                    $unit_name = App\Unit::find($u->parent_id)->first();
                                    $Uname = $unit_name->name;
                                    }else {
                                    $Uname = '-';
                                    }
                                    ?>
                                    <tr>
                                        <td>
                                            <?php echo e($u->name); ?>

                                        </td>
                                        <td>
                                            <?php echo e($u->per_parent); ?>

                                        </td>
                                        <td>
                                            <?php echo e($Uname); ?>

                                        </td>
                                        <td>
                                                <button class="btn btn-primary btn-sm" type="button" onclick="edit(<?php echo e($u->id); ?>)">
                                                    <i class="fa fa-pencil-square-o text-white"> แก้ไข</i>
                                                </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php else: ?>
                            ยังไม่มีหน่วยสินค้า
                            <?php endif; ?>
                            <br>
                        </div>

                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">รายการสินค้าคงเหลือ</h3>

                        </div>
                        <div class="card-body" style="overflow-x: auto;">

                            <?php if(count($unit)>0): ?>
                            <table class="table text-nowrap">
                                <thead>
                                    <tr>
                                        <th scope="col">จำนวน</th>
                                        <th scope="col">หน่วย</th>
                                        <th scope="col"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $stock_total; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <?php echo e($s->total_all); ?>

                                        </td>
                                        <td>
                                            <?php echo e($s->unit->name); ?>

                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php else: ?>
                            ยังไม่มีสต็อกสินค้า
                            <?php endif; ?>
                            <br>
                        </div>

                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-md-12">
                    <!-- Default box -->

                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">นำเข้าสินค้า</h3>

                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <?php if($errors->any()): ?>
                                    <div class="alert alert-danger">
                                        <ul>
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                    <?php endif; ?>

                                    <div class="form-group" hidden>
                                        <label>รหัสพนักงาน</label> <?php echo e(Form::text('emp_id', '1',['class'=>'form-control ', 'placeholder' => 'รหัสพนักงาน...'
                                                    ,'autocomplete' => 'off','required'])); ?>

                                        <?php if($errors->has('emp_id')): ?>
                                        <div class="invalid-feedback"><?php echo e($errors->first('emp_id')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="form-group">
                                        <label>Lot Number สินค้า</label>
                                        <?php echo e(Form::select('lot_id', App\LotNumber::where('product_id', $product->id)->pluck('lot',
                                                    'id'), null, ['class' => 'selectpicker form-control dynamic', 'placeholder' => 'กรุณาเลือก Lot Number...'
                                                    , 'required','data-live-search="true"','id'=>'SelAddress','onchange'=>'testS(this.value)'])); ?>

                                        <?php if($errors->has('lot_id')): ?>
                                        <div class="invalid-feedback"><?php echo e($errors->first('lot_id')); ?></div>
                                        <?php endif; ?>
                                        <div class="my-2 text-right"><a
                                                href="<?php echo e(route ('stock.lot_index',['product_id'=>$product->id])); ?>">แก้ไข/เพิ่ม</a>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="exampleFormControlInput1">วันที่นำเข้า (ค.ศ. ตัวอย่าง
                                            12/12/2019)</label>
                                        <?php echo e(Form::date('date', $DateNow,['class'=>'form-control DaddrDefault',
                                                                        'placeholder' => 'วันที่...','required', 'id' => 'date'
                                                                        ,'onchange' => 'highlight_box_address(this.id)','autocomplete'=>'off'])); ?>

                                        <?php if($errors->has('date')): ?>
                                        <div class="invalid-feedback"><?php echo e($errors->first('date')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="form-group">
                                        <label>จำนวน</label> <?php echo e(Form::number('total', null,['class'=>'form-control ', 'placeholder' => 'จำนวน...'
                                                    ,'autocomplete' => 'off','required'])); ?>

                                        <?php if($errors->has('total')): ?>
                                        <div class="invalid-feedback"><?php echo e($errors->first('total')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="form-group">
                                        <label>หน่วย</label>
                                        <?php echo e(Form::select('unit_id', App\Unit::where('product_id', $product->id)->pluck('name',
                                                'id'), null, ['class' => 'form-control dynamic', 'placeholder' => 'กรุณาเลือกหน่วย...'
                                                , 'required','id'=>'SelAddress','onchange'=>'testS(this.value)'])); ?>

                                        <?php if($errors->has('unit_id')): ?>
                                        <div class="invalid-feedback"><?php echo e($errors->first('unit_id')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="exampleFormControlInput1">หมายเหตุ</label> <?php echo e(Form::text('remark', null,['class'=>'form-control ',
                                                'autocomplete'=>'off','placeholder'=>'-'])); ?>

                                        <?php if($errors->has('remark')): ?>
                                        <div class="invalid-feedback"><?php echo e($errors->first('remark')); ?></div>
                                        <?php endif; ?>
                                    </div>
                                    <!-- card.// class="text-right" -->

                                    <input type="text" name="product_id" value="<?php echo e($product->id); ?>" hidden>

                                    <div>
                                        <button type="submit" class="btn btn-primary mt-3">ยืนยัน</button>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                    <!-- /.card -->
                </div>

            </div>

        </form>
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('footerscript'); ?>

<script>
    function edit(id){

        var url = '<?php echo e(route('stock.unit_edit',['unit_id'=>':id'])); ?>';
        url = url.replace(':id',id);
        // alert(url);
        // alert(id);

        window.location.replace(url);
    }
</script>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","success");
</script>
<?php endif; ?>

<!-- Latest compiled and minified CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/css/bootstrap-select.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/js/bootstrap-select.min.js"></script>

<script>
    $('select').selectpicker();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cp266440/public_html/store.richendless.co.th/shopping/resources/views/backend/stock/create.blade.php ENDPATH**/ ?>