<?php $__env->startSection('content'); ?>

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Dashboard</h1>
            </div>
            <!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">ราคาสินค้า</li>
                </ol>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>ราคาสินค้า</h3>
                    </div>
                    <div class="card-body">

                        

                        <table class="table" id="price-table">
                            <thead>
                                <tr>
                                    <th>รหัส</th>
                                    <th>ชื่อสินค้า</th>
                                    <th>หน่วย</th>
                                    <th>ราคา/หน่วย</th>
                                    <th>เครื่องมือ</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>


        </div>
        <!-- end row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerscript'); ?>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","success");
</script>
<?php endif; ?>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js"></script>

<script>
    var table = $('#price-table').DataTable({
    serverSide: true,
    ajax: "<?php echo e(route('price.getPriceAjax')); ?>",
    columns: [
        { name: 'product_id' },
        { name: 'product.name' },
        { name: 'unit' },
        { name: 'price' },
        // { name: 'category.name', orderable: false },
        { name: 'action', orderable: false, searchable: false }
    ],
});

// $('#price-table').on('click','tr',function(){
//     alert($(this).data('id'));
// });

$('#price-table').on('click','#btnDel',function(e){
    var tr = $(this).closest('tr');
    var row = table.row(tr);

    var id = row.data().DT_RowData.id;
    //alert(id);

    e.preventDefault();

    var url = '<?php echo e(route('category.destroy',['id'=>':id'])); ?>';
    url = url.replace(':id',id);
    //alert(url);

    $('#frmDel').attr('action',url).submit();

});

$('#price-table').on('click','#btnEdit',function(e){
    var tr = $(this).closest('tr');
    var row = table.row(tr);

    var id = row.data().DT_RowData.id;
    //alert(id);

    e.preventDefault();

    var url = '<?php echo e(route('price.edit',['id'=>':id'])); ?>';
    url = url.replace(':id',id);
    //alert(url);

    window.location.replace(url);

});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/shopping/resources/views/backend/price/index.blade.php ENDPATH**/ ?>