<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name')); ?></title>

    <!-- Bootstrap core CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">

    <!-- Custom styles for this template -->
    <link href="<?php echo e(asset('css/theme.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <div id="app">

        <!-- Navigation -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-success fixed-top">
            <div class="container">
                <a class="navbar-brand" href="<?php echo e(route('welcome')); ?>">
                    <img src="<?php echo e(asset('../shopping/storage/app/public/images/LogoDiag.png')); ?>" alt="" width="130" height="36"> </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarResponsive"
                    aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarResponsive">
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item <?php echo e(request()->routeIs('welcome') ? 'bg-light':''); ?>">
                            <a class="nav-link" href="<?php echo e(route('welcome')); ?>">หน้าหลัก
                                <span class="sr-only">(current)</span>
                            </a>
                        </li>
                        <li class="nav-item <?php echo e(request()->routeIs('about') ? 'bg-light':''); ?>">
                            <a class="nav-link" href="<?php echo e(route('about')); ?>">เกี่ยวกับเรา</a>
                        </li>

                        <?php if(auth()->guard()->check()): ?>
                        <li class="nav-item <?php echo e(request()->routeIs('cart.index') ? 'bg-light':''); ?>">
                            <a class="nav-link" href="<?php echo e(route('cart.index')); ?>">
                                ตะกร้าสินค้า
                                <span class="badge badge-warning">
                                    <?php echo e(App\Cart::where('user_id',auth()->user()->id)->count('product_id')); ?>

                                </span>
                            </a>
                        </li>
                        <?php endif; ?>

                        <li class="nav-item <?php echo e(request()->routeIs('contact.index') ? 'bg-light':''); ?>">
                            <a class="nav-link" href="<?php echo e(route('contact.index')); ?>">ติดต่อเรา</a>
                        </li>

                        
                        <?php if(auth()->guard()->guest()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('login')); ?>">เข้าสู่ระบบ</a>
                        </li>
                        <?php if(Route::has('register')): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('register')); ?>">ลงทะเบียน</a>
                        </li>
                        <?php endif; ?>
                        <?php else: ?>
                        <li class="nav-item dropdown">
                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                welcome <?php echo e(Auth::user()->name); ?> <span class="caret"></span>
                            </a>

                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">

                                
                                <a class="dropdown-item bg-success" href="<?php echo e(route('address.index')); ?>" style="color: green;">
                                    ที่อยู่ของฉัน
                                </a>

                                <a class="dropdown-item bg-success" href="<?php echo e(route('myorder.index')); ?>" style="color: green;">
                                    ออเดอร์ของฉัน
                                </a>

                                <?php if(auth()->check() && auth()->user()->hasRole('Admin')): ?>
                                <a class="dropdown-item bg-success" href="<?php echo e(route('dashboard')); ?>">
                                    Dashboard
                                </a>
                                <?php endif; ?>

                                <a class="dropdown-item bg-danger" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                    <?php echo e(__('Logout')); ?>

                                </a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                    style="display: none;">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </nav>

        <!-- Page Content -->
        <div class="container">

            <?php echo $__env->yieldContent('content'); ?>

        </div>
        <!-- /.container -->

        <!-- Footer -->
        <?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    <?php echo $__env->make('partials.showproduct', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Bootstrap core JavaScript -->
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('../shopping/node_modules/moment/moment.js')); ?>"></script>
    <script src="<?php echo e(asset('../shopping/node_modules/chart.js/dist/Chart.js')); ?>"></script>
    <?php echo $__env->yieldContent('footerscript'); ?>

</body>

</html>
<?php /**PATH /home/cp266440/public_html/store.richendless.co.th/shopping/resources/views/layouts/frontend.blade.php ENDPATH**/ ?>