<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Dashboard <?php echo e(config('app.name')); ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">

</head>

<body class="hold-transition sidebar-mini">
    <div id="app" class="wrapper">

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand bg-white navbar-light border-bottom">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#"><i class="fa fa-bars"></i></a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a href="<?php echo e(route('home')); ?>" class="nav-link">หน้าหลัก</a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                <a href="<?php echo e(route('welcome')); ?>" class="nav-link">ซื้อสินค้า</a>
                </li>
                <li class="nav-item d-none d-sm-inline-block bg-warning">
                        <a class="nav-link" href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault();
                                      document.getElementById('logout-form').submit();">
                         ออกจากระบบ
                     </a>

                     <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                         <?php echo csrf_field(); ?>
                     </form>
                </li>
            </ul>

            <!-- SEARCH FORM -->
            <form class="form-inline ml-3">
                <div class="input-group input-group-sm">
                    <input class="form-control form-control-navbar" type="search" placeholder="Search"
                        aria-label="Search">
                    <div class="input-group-append">
                        <button class="btn btn-navbar" type="submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </form>

            <!-- Right navbar links -->

        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="<?php echo e(route('home')); ?>" class="brand-link">
                <img src="<?php echo e(asset('img/logo.png')); ?>" alt="Logo" class="brand-image img-circle elevation-3"
                    style="opacity: .8">
                <span class="brand-text font-weight-light"><?php echo e(config('app.name')); ?></span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar user panel (optional) -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        
                    </div>
                    <div class="info">
                        <a href="#" class="d-block">Hello, <?php echo e(auth()->user()->name); ?></a>
                        <small class="text-light">
                            ที่อยู่ : <?php echo e(optional(auth()->user()->profile)->address); ?>

                        </small>
                        <br>
                        <small class="text-light">
                            อีเมล์ : <?php echo e(auth()->user()->email); ?>

                            <br>
                            บทบาท : <?php echo e(auth()->user()->getRoleNames()[0]); ?>

                            
                        </small>
                    </div>
                </div>

                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">

                        <li class="nav-header">ข้อมูลหลัก</li>

                        <li class="nav-item">
                        <?php if(auth()->check() && auth()->user()->hasRole('Admin')): ?>
                        <a href="<?php echo e(route('category.index')); ?>" class="nav-link">
                                <i class="nav-icon fa fa-calendar"></i> <p class="d-flex" style="display: inline-block">หมวดสินค้า</p></a>
                        </li>
                        <?php endif; ?>

                        <li class="nav-item has-treeview">
                            <a href="<?php echo e(route('product.index')); ?>" class="nav-link">
                                <i class="nav-icon fa fa-envelope-o"></i> <p class="d-flex">สินค้า</p>
                            </a>
                        </li>

                        <li class="nav-item has-treeview">
                            <a href="<?php echo e(route('product.index2')); ?>" class="nav-link">
                                <i class="nav-icon fa fa-envelope-o"></i> <p class="d-flex">สินค้า Datatables</p>
                            </a>
                        </li>

                    </ul>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <!-- /.content-wrapper -->
        <footer class="main-footer">
            <strong>Copyright &copy; <?php echo e(date('Y')); ?> <a href="http://adminlte.io">AdminLTE.io</a>.</strong> All rights
            reserved.
            <div class="float-right d-none d-sm-inline-block">
                <b>Version</b> 1.0
        </footer>

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->
    </div>
    <!-- ./wrapper -->

    <script src="<?php echo e(asset('js/app.js')); ?>"></script>

    <?php echo $__env->yieldContent('footerscript'); ?>

</body>

</html>
<?php /**PATH D:\xampp\htdocs\shopping\resources\views/layouts/backend.blade.php ENDPATH**/ ?>