<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                        <h3>Lot Number
                        <span class="ml-2">
                            <a href="<?php echo e(route('stock.lot_create',['product_id'=>$product_id])); ?>" class="btn btn-success mb-2">
                                <i class="fa fa-plus-circle text-white"> เพิ่ม</i>
                            </a>
                        </span>
                    </h3>
                </div>
                <div class="card-body" style="overflow-x: auto;">
                    <table class="table text-nowrap">
                        <thead>
                            <tr>
                                <th scope="col">Lot/Serial Number</th>
                                <th scope="col">exp</th>
                                <th scope="col">หมายเหตุ</th>
                                <th scope="col"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $lot_number; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indexKey => $Lot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                                <td>
                                    <?php echo e($Lot->lot); ?>

                                </td>
                                <td>
                                    <?php echo e($Lot->exp); ?>

                                </td>
                                <td>
                                    <?php echo e($Lot->remark); ?>

                                </td>
                                <td>
                                    <button class="btn btn-primary btn-sm" onclick="edit(<?php echo e($Lot->id); ?>)">
                                        <i class="fa fa-pencil-square-o text-white"> แก้ไข</i>
                                    </button>
                                    
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <br>
                    <?php echo e($lot_number->links()); ?>

                </div>
            </div>

            <span class="ml-2">
                <a href="<?php echo e(route('stock.addStock',['product_id'=>$product_id])); ?>" class="btn btn-primary mb-2">
                    <i class="fa fa-chevron-circle-left text-white"> Back กลับ</i>
                </a>
            </span>

        </div>


    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerscript'); ?>

<script>
    function edit(id){

        var url = '<?php echo e(route('stock.lot_edit',['lot_id'=>':id'])); ?>';
        url = url.replace(':id',id);
        // alert(url);
        // alert(id);

        window.location.replace(url);
    }
</script>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","success");
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/shopping/resources/views/backend/stock/lot/index.blade.php ENDPATH**/ ?>