<?php $__env->startSection('content'); ?>

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Dashboard</h1>
            </div>
            <!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">ประเภทสินค้า</li>
                </ol>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>สินค้าทั้งหมด <?php echo e($product->total()); ?> รายการ</h3>
                    </div>
                    <div class="card-body">

                        <a href="<?php echo e(route ('product.create')); ?>" class="btn btn-primary btn-lg">เพิ่มสินค้า</a>

                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">รหัส</th>
                                    <th scope="col">ชื่อสินค้า</th>
                                    <th scope="col">ราคา</th>
                                    <th scope="col">รูปภาพ</th>
                                    <th scope="col">ประเภท</th>
                                    <th scope="col">เครื่องมือ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th scope="row"><?php echo e($p->id); ?></th>
                                    <td><?php echo e(str_limit($p->name,20)); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('price.indexP',['product_id'=>$p->id])); ?>"
                                            class="btn btn-success btn-sm d-inline mr-2">
                                            <li class="fa fa-money text-white">

                                            </li>
                                        </a>
                                    </td>
                                    <td>
                                        <img src="<?php echo e(asset('/../storage/app/public/images/resize/'.$p->picture)); ?>"
                                            width="60">
                                        
                                    </td>
                                    <td><?php echo e($p->category->name); ?></td>
                                    <td>

                                        
                                        <a href="<?php echo e(route('product.edit',['id'=>$p->id])); ?>"
                                            class="btn btn-info btn-sm d-inline mr-2">
                                            <li class="fa fa-pencil text-white">

                                            </li>
                                        </a>
                                        <form method="POST" action="<?php echo e(route('product.destroy',['id'=>$p->id])); ?>"
                                            class="d-inline"
                                            onsubmit="return confirm('คุณต้องการลบข้อมูลใช่ หรือไม่?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button class="btn btn-danger btn-sm">
                                                <li class="fa fa-trash text-white"></li>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                        <br>
                        <?php echo e($product->links()); ?>

                    </div>
                </div>
            </div>


        </div>
        <!-- end row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerscript'); ?>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","success");
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/shopping/resources/views/backend/product/index.blade.php ENDPATH**/ ?>