<?php $__env->startSection('content'); ?>

<div class="row my-4">
    <!-- /.col-lg-3 -->

    <div class="col-lg-12">

        <form novalidate class="<?php echo e(($errors->any()) ? 'was-validated' : 'needs-validation'); ?>" method="post"
            enctype="multipart/form-data" action="<?php echo e(route('order.confirm')); ?>">
            <?php echo csrf_field(); ?>

            <h3>ทำการสั่งซื้อ</h3>

            <br>
            <h5>ที่อยู่ในการจัดส่ง</h5>
            <input type="number" name="address_id" value="<?php echo e($address->id); ?>" hidden>
            <div class="card">
                <table class="table table-hover shopping-cart-wrap">
                    <thead class="text-muted">
                        <tr>
                            <th scope="col">ชื่อ</th>
                            <th scope="col">ที่อยู่</th>
                            <th scope="col">เบอร์โทรศัพท์</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>
                                <figure class="media">
                                    <figcaption class="media-body">
                                        <h6 class="title text-truncate"><?php echo e($address->name); ?></h6>
                                    </figcaption>
                                </figure>
                            </td>
                            <td>
                                <figure class="media">
                                    <figcaption class="media-body">
                                        <p class="title text-truncate">
                                            <?php echo e($address->address); ?><br>
                                            <?php echo e('ตำบล/แขวง : '.$address->sub_district); ?><br>
                                            <?php echo e(' อำเภอ/เขต : '.$address->district); ?><br>
                                            <?php echo e('จังหวัด : '.$address->province); ?><br>
                                            <?php echo e(' รหัสไปรษณีย์ : '.$address->zipcode); ?>

                                        </p>
                                    </figcaption>
                                </figure>
                            </td>
                            <td>
                                <figure class="media">
                                    <figcaption class="media-body">
                                        <h6 class="title text-truncate"><?php echo e($address->tel); ?></h6>
                                    </figcaption>
                                </figure>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <h5>รายการสินค้า</h5>

            <?php if(count($listCart) > 0): ?>
            <div class="card">
                <table class="table table-hover shopping-cart-wrap">
                    <thead class="text-muted">
                        <tr>
                            <th>#</th>
                            <th scope="col">ชื่อสินค้า</th>
                            <th scope="col" width="120">จำนวน</th>
                            <th scope="col" width="120">ราคาต่อชิ้น</th>
                            <th scope="col" width="120">ราคา</th>
                        </tr>
                    </thead>
                    <tbody>

                        <p style="display:none"><?php echo e($sumAll = 0); ?></p>
                        <?php $__currentLoopData = $listCart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indexKey => $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p style="display:none"><?php echo e($sumAll += ($cart->price)*($cart->pivot->qty)); ?></p>
                        <tr>
                            <td><input type="checkbox" name="product_id[]" value="<?php echo e($cart->id); ?>" checked="checked"
                                    style='display:none;'> <?php echo e(++$indexKey); ?></td>
                            <td>
                                <figure class="media">
                                    <figcaption class="media-body">
                                        <h6 class="title text-truncate"><?php echo e($cart->name); ?></h6>
                                    </figcaption>
                                </figure>
                            </td>
                            <td>

                                <?php echo e($cart->pivot->qty); ?>


                            </td>
                            <td>
                                <div class="price-wrap">
                                    <var id="priceT<?php echo e($indexKey); ?>" class="price"><?php echo e($cart->price); ?></var>
                                </div>
                                <!-- price-wrap .// -->
                            </td>
                            <td>
                                <div class="price-wrap">
                                    <var id="totalT<?php echo e($indexKey); ?>" class="price">
                                        <?php echo e(number_format(($cart->price)*($cart->pivot->qty),2)); ?></var>
                                </div>
                                <!-- price-wrap .// -->
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="table-active">
                            <td></td>
                            <td></td>
                            <td><span id="Qsum" style="font-size:150%"><?php echo e($sumQty); ?></span> ชิ้น</td>
                            <td></td>
                            <td>
                                <span style="font-size:150%" id="Tsum"><?php echo e(number_format($sumAll,2)); ?></span>
                            </td>
                            <td><span>บาท</span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- card.// -->

            

            <input type="number" name="total" value="<?php echo e($sumAll); ?>" hidden>

            

            <h5>หมายเหตุ</h5>
            <div class="card">
                <div class="my-2 mx-2">
                    <?php echo Form::textarea('remark',$remark,['class'=>'form-control', 'rows' => 3, 'cols' => 40]); ?>

                </div>
            </div>

            <div class="text-right">
                
                
                <button type="button" class="btn btn-danger mt-3" onclick="G2Cart()">ยกเลิก</button>
                <button type="submit" class="btn btn-primary mt-3">ยืนยันคำสั่งซื้อ</button>
            </div>


        </form>

        <?php else: ?>

        <p>--- ยังไม่ได้เลือกสินค้า ---</p>

        <?php endif; ?>


    </div>
    <!-- /.col-lg-9 -->

</div>
<!-- /.row -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerscript'); ?>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","success");
</script>
<?php endif; ?>

<script>
    function testF(){
    document.getElementById('testSS').innerHTML = '555';
}
</script>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js"></script>

<script>
function G2Cart(){
    window.location.href = '<?php echo e(route('cart.index')); ?>';
    //alert('5555');
}
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/shopping/resources/views/order/checkout.blade.php ENDPATH**/ ?>