<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h3>แก้ไขที่อยู่</h3>
                </div>
                <div class="card-body">
                    <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <?php endif; ?>

                    <?php echo Form::model($address, ['novalidate','route' => ['address.update',$address->id], 'method' =>
                    'put'
                    ,'class'=> ($errors->any()) ? 'was-validated' : 'needs-validation']); ?>

                    

                    <div class="form-group">
                        <label for="exampleFormControlInput1">ชื่อ</label> <?php echo e(Form::text('name', null,['class'=>'form-control',
                                    'required'])); ?>

                        <?php if($errors->has('name')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('name')); ?></div>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="exampleFormControlInput1">ที่อยู่</label> <?php echo e(Form::text('address', null,['class'=>'form-control ',
                                        'required'])); ?>

                        <?php if($errors->has('address')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('address')); ?></div>
                        <?php endif; ?>
                    </div>

                    <div class="form-inline">
                        <div class="form-group mr-2 mb-4">
                            <div class="form-group">
                                <label for="exampleFormControlSelect1">จังหวัด : </label>
                                <?php echo e(Form::select('province', DB::table('_provinces')->orderBy('name_th')->pluck('name_th','name_th'), null,
                            ['class' => 'form-control dynamic', 'placeholder' => 'เลือกจังหวัด...', 'required'
                                        , 'data-dependent' => 'districts' , 'id' => 'provinces'])); ?>

                                <?php if($errors->has('provinces')): ?>
                                <div class="invalid-feedback"><?php echo e($errors->first('provinces')); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group mr-2 mb-4">
                            <div class="form-group">
                                <label for="exampleFormControlSelect2">อำเภอ/เขต : </label>
                                <?php echo e(Form::select('district',$district->pluck('name_th','name_th'), null
                                , ['class' => 'form-control dynamic', 'placeholder' => 'เลือกอำเภอ/เขต...', 'required'
                                , 'data-dependent' => 'sub_districts' , 'id' => 'districts']
                                )); ?>

                                <?php if($errors->has('districts')): ?>
                                <div class="invalid-feedback"><?php echo e($errors->first('districts')); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group mr-2 mb-4">
                            <div class="form-group">
                                <label for="exampleFormControlSelect2">ตำบล/แขวง : </label>
                                <?php echo e(Form::select('sub_district',$sub_district->pluck('name_th','name_th'), null
                                , ['class' => 'form-control dynamic', 'placeholder' => 'เลือกตำบล/แขวง...', 'required'
                                , 'data-dependent' => 'zipcode' , 'id' => 'sub_districts']
                                )); ?>

                                <?php if($errors->has('sub_districts')): ?>
                                <div class="invalid-feedback"><?php echo e($errors->first('sub_districts')); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>

                    </div>
                    

                    <div class="form-inline">

                        <div class="form-group mr-2">
                            <label for="exampleFormControlInput1">รหัสไปรษณีย์ :</label> <?php echo e(Form::text('zipcode', null,['class'=>'form-control ',
                                    'required', 'id' => 'zipcode'])); ?>

                            <?php if($errors->has('zipcode')): ?>
                            <div class="invalid-feedback"><?php echo e($errors->first('zipcode')); ?></div>
                            <?php endif; ?>
                        </div>

                        <div class="form-group">
                            <label for="exampleFormControlInput1">โทรศัพท์ :</label> <?php echo e(Form::text('tel', null,['class'=>'form-control ',
                                    'required'])); ?>

                            <?php if($errors->has('tel')): ?>
                            <div class="invalid-feedback"><?php echo e($errors->first('tel')); ?></div>
                            <?php endif; ?>
                        </div>

                    </div>

                    <button type="submit" class="btn btn-primary mt-5">บันทึก</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerscript'); ?>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","success");
</script>
<?php endif; ?>

<script>
    $(document).ready(function(){
    $('.dynamic').change(function(){
        if($(this).val() != '')
        {
            var select = $(this).attr("id");
            var value = $(this).val();
            //var name = $(this).attr("name");
            var dependent = $(this).data("dependent");
            var _token = $('input[name="_token"]').val();

            $.ajax({
                url:"<?php echo e(route('address.fetch')); ?>",
                method:"POST",
                data:{select:select, value:value, _token:_token
                , dependent:dependent},
                success:function(result)
                {
                    if(dependent != 'zipcode'){
                        $("#"+dependent).html(result);
                        //$("#zipcode").val('5555');
                        //alert(result);

                    }else if(dependent == 'zipcode'){
                        $("#"+dependent).val(result);
                    }
                    //alert(result);
                }
            })
            //alert(value);
        }
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cp266440/public_html/store.richendless.co.th/shopping/resources/views/address/edit.blade.php ENDPATH**/ ?>