<?php $__env->startSection('content'); ?>

<div class="row my-4">
    <div class="col-md-12">
        <div class="card-header">
            <h3>ราคาสินค้า "<?php echo e($product->name); ?>"</h3>
        </div>
        <div class="card">
            <div class="card-body">

                <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
                <h5>ราคากลางสินค้า</h5>
                <div>

                    

                    
                    <?php if(count($priceMid) > 0): ?>

                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">หน่วย</th>
                                <th scope="col">ราคา/หน่วย</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $priceMid; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($p->unit); ?></td>
                                <td><?php echo e(number_format($p->price,2)); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <br>
                    <?php else: ?>

                    <p class="mt-4">--- ยังไม่มีราคาสินค้า ---</p>

                    <?php endif; ?>
                </div>

                <h5>เพิ่ม ราคาสินค้า "<span style="color:blue;font-size:120%"><?php echo e($address->name); ?></span>"</h5>

                <?php echo Form::open(['novalidate','route' => 'price.setname', 'method' => 'post','class'=>
                ($errors->any()) ? 'was-validated' : 'needs-validation']); ?>

                

                <div>
                    <div class="form-inline">

                        <div class="form-inline mt-3 mr-3" hidden>
                            <label for="exampleFormControlInput1">product id : </label> <?php echo e(Form::text('product_id', $product->id,['class'=>'form-control ',
                                                                    'required'])); ?>

                            <?php if($errors->has('product_id')): ?>
                            <div class="invalid-feedback"><?php echo e($errors->first('product_id')); ?></div>
                            <?php endif; ?>

                        </div>

                        <div class="form-inline mt-3 mr-3" hidden>
                            <label for="exampleFormControlInput1">address id : </label> <?php echo e(Form::text('address_id', $address->id,['class'=>'form-control ',
                                                            'required'])); ?>

                            <?php if($errors->has('address_id')): ?>
                            <div class="invalid-feedback"><?php echo e($errors->first('address_id')); ?></div>
                            <?php endif; ?>

                        </div>

                        <div class="form-inline mt-3 mr-3">
                            <label for="exampleFormControlInput1">ชื่อสินค้า : </label> <?php echo e(Form::text('product_name'
                                , $productN ,['class'=>'form-control ','required'])); ?>

                            <?php if($errors->has('product_name')): ?>
                            <div class="invalid-feedback"><?php echo e($errors->first('product_name')); ?></div>
                            <?php endif; ?>

                        </div>
                        <button type="submit" class="btn btn-warning mt-3">เปลี่ยนชื่อสินค้า</button>
                    </div>

                </div>

                </form>

                <?php echo Form::open(['novalidate','route' => 'price.store', 'method' => 'post','class'=>
                ($errors->any()) ? 'was-validated' : 'needs-validation']); ?>

                

                <div class="form-inline">

                    <div class="form-inline mt-3 mr-3" hidden>
                        <label for="exampleFormControlInput1">product id : </label> <?php echo e(Form::text('product_id', $product->id,['class'=>'form-control ',
                                                            'required'])); ?>

                        <?php if($errors->has('product_id')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('product_id')); ?></div>
                        <?php endif; ?>

                    </div>

                    <div class="form-inline mt-3 mr-3" hidden>
                        <label for="exampleFormControlInput1">address id : </label> <?php echo e(Form::text('address_id', $address->id,['class'=>'form-control ',
                                                    'required'])); ?>

                        <?php if($errors->has('address_id')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('address_id')); ?></div>
                        <?php endif; ?>

                    </div>

                    <div class="form-inline mt-3 mr-3">
                        <label for="exampleFormControlInput1">หน่วย : </label> <?php echo e(Form::text('unit', null,['class'=>'form-control ',
                                            'required'])); ?>

                        <?php if($errors->has('unit')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('unit')); ?></div>
                        <?php endif; ?>

                    </div>

                    <div class="form-inline mt-3 mr-3">
                        <label for="exampleFormControlInput1">ราคาต่อหน่วย :</label> <?php echo e(Form::text('price', null,['class'=>'form-control ',
                                        'required'])); ?>

                        <?php if($errors->has('price')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('price')); ?></div>
                        <?php endif; ?>

                    </div>

                    <button type="submit" class="btn btn-success mt-3">เพิ่ม</button>

                </div>

                </form>


            </div>
            <div class="card-body">

                

                
                <?php if(count($price) > 0): ?>

                <table class="table">
                    <thead>
                        <tr>
                            <th scope="col">หน่วย</th>
                            <th scope="col">ราคา/หน่วย</th>
                            <th scope="col">เครื่องมือ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $price; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($p->unit); ?></td>
                            <td><?php echo e(number_format($p->price,2)); ?></td>
                            <td>
                                <a href="<?php echo e(route('price.edit',['id'=>$p->id])); ?>"
                                    class="btn btn-info btn-sm d-inline mr-2">
                                    <li class="fa fa-pencil text-white">

                                    </li>
                                </a>
                                <form method="POST" action="<?php echo e(route('price.destroy',['id'=>$p->id])); ?>"
                                    class="d-inline" onsubmit="return confirm('คุณต้องการลบข้อมูลใช่ หรือไม่?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-danger btn-sm">
                                        <li class="fa fa-trash text-white"></li>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
                <br>
                <?php echo e($price->links()); ?>


                <?php else: ?>

                <p class="mt-4">--- ยังไม่มีราคาสินค้า ---</p>

                <?php endif; ?>
            </div>
        </div>
        <a href="<?php echo e(route('cart.cartsale',['address_id'=>$address->id])); ?>">
            <button type="button" class="btn btn-primary">กลับ</button>
        </a>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerscript'); ?>

<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

<?php if(session('feedback')): ?>
<script>
    swal("<?php echo e(session('feedback')); ?>","ผลการทำงาน","success");
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/shopping/resources/views/sale/price_edit.blade.php ENDPATH**/ ?>