<?php
//use Illuminate\Routing\Route;
use Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::group(['middleware' => 'auth'], function () {

    //Welcome
    Route::get('/', 'WelcomeController@index')->name('welcome');
    Route::get('/category', 'WelcomeController@getCategory')->name('welcome.category');
    Route::get('/categoryajax', 'WelcomeController@getCategoryAjax')->name('categoryajax');
    Route::get('/category/{id}', 'WelcomeController@show')->name('welcome.show');
    Route::post('/welcome/show9', 'WelcomeController@show9')->name('welcome.show9');

    Route::get('/about', function () {

        $email = 'diagforlife8@gmail.com';
        $tel = '888';
        $drinks = ['coke', 'pepsi', 'greentea'];

        return view('about', [
            'email' => $email,
            'tel' => $tel,
            'drinks' => $drinks
        ]);
    })->name('about');

    Route::get('contact', 'ContactController@index')->name('contact.index');

    Route::get('/home', 'HomeController@index')->name('home');
    //END Welcome

    Route::get('/dashboard', 'HomeController@dashboard')->name('dashboard');

    //Route::get('/backend/category', 'CategoryController@index')->name('category.index')->middleware('role:Admin');
    //Route::get('/backend/category', 'CategoryController@index')->middleware('admin')->name('category.index');
    Route::get('/backend/category/store', 'CategoryController@store')->name('category.store');

    Route::resource('/backend/category', 'CategoryController')->middleware('role:Admin');

    Route::get('/backend/product', 'ProductController@index')->name('product.index')->middleware('permission:product.index');
    Route::resource('/backend/product', 'ProductController')->except(['index'])->middleware('role:Admin');

    //cart
    Route::get('/cart', 'CartController@index')->name('cart.index');
    //Route::get('/cart/{product_id}', 'CartController@store')->name('cart.store');['as' => 'user.attendance', 'uses' => 'UserController@attendance']
    Route::get('/cart/{product_id}/{newqty}', 'CartController@store')->name('cart.store');
    Route::get('/cart/{product_id}/fn/delete', 'CartController@delete')->name('cart.delete');
    Route::get('/cart/checkout/cart', 'CartController@confirm')->name('cart.confirm');
    Route::post('/cart/fetch', 'CartController@fetch')->name('cart.fetch');
    //Route::post('/cart/add2cart','CartController@add2cart')->name('cart.add2cart');cart_sale
    //Sale
    Route::get('/cart_sale/{address_id}', 'CartController@cart_sale')->name('cart.cartsale');
    Route::get('/price_sale/{product_id}/{address_id}', 'CartController@price_sale')->name('cart.pricesale');


    //order
    // Route::get('/myorders', 'OrderController@index2')->name('myorders');
    // Route::resource('/order', 'OrderController')->middleware('role:Admin');
    // Route::get('/checkout', 'OrderController@checkout')->name('order.checkout');
    // Route::post('/order/confirm', 'OrderController@confirm')->name('order.confirm');
    Route::resource('/myorder', 'MyorderController');
    Route::get('/Error', 'MyorderController@error')->name('myorder.error');
    Route::get('/reuse/{id}', 'MyorderController@reuse')->name('myorder.reuse');
    Route::get('/backend/order/pending', 'MyorderController@pending')->name('myorder.pending')->middleware('role:Admin');
    Route::get('/backend/order/confirmed', 'MyorderController@confirmed')->name('myorder.confirmed')->middleware('role:Admin');


    //address
    Route::resource('/address', 'AddressController');
    Route::get('/getalladdress', 'AddressController@getAddressAjax')->name('address.getAddressAjax');
    Route::post('/address/fetch', 'AddressController@fetch')->name('address.fetch');

    //laratables
    Route::get('/backend/product_', 'ProductController@index2')->name('product.index2');
    Route::post('/backend/product_/fetch', 'ProductController@fetch')->name('product.fetch');
    Route::get('/backend/getallproduct', 'ProductController@getProductAjax')->name('product.getProductAjax');

    //Route::get('/backend/category2','CategoryController@category2')->name('category.catagory2');
    Route::get('/backend/getallcategory', 'CategoryController@getCategoryAjax')->name('category.getCategoryAjax');

    //Prices
    Route::resource('/price', 'PriceController');
    Route::get('/backend/price/create/{product_id}', 'PriceController@createP')->name('price.createP');
    Route::get('/backend/price/{product_id}', 'PriceController@indexP')->name('price.indexP');
    Route::get('/backend/getallprice', 'PriceController@getPriceAjax')->name('price.getPriceAjax');
    Route::post('/price/getprice', 'PriceController@getPrice')->name('price.getprice');
    Route::post('/price/setname', 'PriceController@setName')->name('price.setname');

    //Print, PDF
    Route::get('/print', 'PrintController@index')->name('print.index');
    Route::get('/pdf/order/{order_id}', 'PrintController@export')->name('print.export');
    Route::get('/export2', 'PrintController@test')->name('print.test');

    //confirm order & Invoice
    Route::resource('/invoice', 'InvoiceController')->middleware('role:Admin');
    Route::get('/confirm/{id}', 'InvoiceController@confirm')->name('invoice.confirm')->middleware('role:Admin');

    //Stock
    Route::resource('/stock', 'StockController')->middleware('role:Admin');
    Route::get('/stock/category/{category_id}', 'StockController@category')->name('stock.category');
    Route::get('/stock/preImport/{xx}', 'StockController@preImport')->name('stock.preImport');
    Route::get('/stock/addStock/{product_id}', 'StockController@addStock')->name('stock.addStock');
    //Lot Number
    Route::get('/stock/lot_number/table/{product_id}', 'StockController@lot_index')->name('stock.lot_index');
    Route::get('/stock/lot_number/create/{product_id}', 'StockController@lot_create')->name('stock.lot_create');
    Route::get('/stock/lot_number/edit/{lot_id}', 'StockController@lot_edit')->name('stock.lot_edit');
    Route::post('/stock/lot_number/store/', 'StockController@lot_store')->name('stock.lot_store');
    Route::post('/stock/lot_number/update/', 'StockController@lot_update')->name('stock.lot_update');
    //Unit
    Route::get('/stock/product_unit/table/{product_id}', 'StockController@unit_index')->name('stock.unit_index');
    Route::get('/stock/product_unit/create/{product_id}', 'StockController@unit_create')->name('stock.unit_create');
    Route::get('/stock/product_unit/edit/{unit_id}', 'StockController@unit_edit')->name('stock.unit_edit');
    Route::post('/stock/product_unit/store/', 'StockController@unit_store')->name('stock.unit_store');
    Route::post('/stock/product_unit/update/', 'StockController@unit_update')->name('stock.unit_update');
    //Withdraw
    Route::get('/stock/withdraw/index/', 'StockController@withdraw_index')->name('stock.withdraw_index');
    Route::post('/stock/withdraw_fetch', 'StockController@withdraw_fetch')->name('stock.withdraw_fetch');
    Route::post('/stock/withdraw_fetch2', 'StockController@withdraw_fetch2')->name('stock.withdraw_fetch2');
    //History
    Route::get('/stock/history/index/{product_id}', 'StockController@history_index')->name('stock.history_index');
    Route::post('/stock/search_fetch', 'StockController@search_fetch')->name('stock.search_fetch');
    //Detail
    Route::get('/stock/detail/{product_id}', 'StockController@stockDetail')->name('stock.stockDetail');
    Route::get('/stock/barcode/{stock_id}', 'StockController@stockBarcode')->name('stock.stockBarcode');
    //Search
    Route::post('/stock/fetch', 'StockController@fetch')->name('stock.fetch');
    //Select ALL
    Route::get('/SelAll/{category_id}', 'StockController@SelAll')->name('stock.SelAll');
});
