@extends('layouts.frontend')

@section('content')

<div class="row">

    <div class="col-lg-3">

        <h1 class="my-4" onclick="window.location='{{route('welcome')}}'">สินค้า</h1>
        <!-- Search form -->
        <form class="form-inline ">
            <input class="form-control form-control-sm mr-3 w-75" type="text" placeholder="Search" aria-label="Search"
                onkeyup="Search9(this.value)">
            <i class="fa fa-search" aria-hidden="true"></i>
        </form>
        <br>
        <div class="list-group" id="catagory_list">
            @foreach ($category as $c)
            <a href="{{ route('welcome.show',['id'=>$c->id]) }}" class="list-group-item">{{$c->name}}</a>
            @endforeach
        </div>

    </div>
    <!-- /.col-lg-3 -->

    <div class="col-lg-9">

        {{-- <div id="carouselExampleIndicators" class="carousel slide my-4" data-ride="carousel">
            <ol class="carousel-indicators">
                <li data-target="#carouselExampleIndicators" data-slide-to="0" class="active"></li>
                <li data-target="#carouselExampleIndicators" data-slide-to="1"></li>
                <li data-target="#carouselExampleIndicators" data-slide-to="2"></li>
            </ol>
            <div class="carousel-inner" role="listbox">
                <div class="carousel-item active">
                    <img class="d-block img-fluid" src="https://picsum.photos/900/350" alt="First slide">
                </div>
                <div class="carousel-item">
                    <img class="d-block img-fluid" src="https://picsum.photos/900/351" alt="Second slide">
                </div>
                <div class="carousel-item">
                    <img class="d-block img-fluid" src="https://picsum.photos/900/352" alt="Third slide">
                </div>
            </div>
            <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div> --}}

        <div class="row mt-5" id="Show9">
            @foreach ($product as $p)

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card h-100">
                    <a href="#"><img class="card-img-top" src="{{asset('../shopping/storage/app/public/images/'.$p->picture)}}" alt=""></a>
                    <div class="card-body">
                        <h4 class="card-title">
                            <a href="#">{{$p->name}}</a>
                        </h4>
                        <h5>{{$p->price}}</h5>

                    </div>
                    <div class="card-footer">
                        <small class="text-muted">&#9733; &#9733; &#9733; &#9733; &#9734;</small>
                    </div>
                </div>
            </div>

            @endforeach

        </div>
        <!-- /.row -->

    </div>
    <!-- /.col-lg-9 -->
</div>
@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

<script>
    function Search9(key){

    var _token = $('input[name="_token"]').val();

        if(key!=''){
            runAjax(key);
        }else{
            document.getElementById('catagory_list').style.display = 'block';
        }

        function runAjax(key) {
            $.ajax({
                url:"{{ route('welcome.show9')}}",
                method:"POST",
                data:{key:key, _token:_token},
                success:function(result)
                {
                    $("#Show9").html(result);
                }
            });
            document.getElementById('catagory_list').style.display = 'none';
        }
    }
</script>
<script>
        function add2cart(id,qty){
            //var idPQ = ;
            // var PQ = document.getElementById('PQ'+id).value;

            var url = '{{ route('cart.store',['product_id'=>':id','newqty'=>':qty']) }}';

            url = url.replace(':id', id);
            url = url.replace(':qty', '1');

            swal("{{session('feedback')}}","เพิ่มลงตะกร้าสินค้าเรียบร้อย","success");

            window.location.href=url;

            //alert(url);
        }
    </script>
@endsection
