@extends('layouts.frontend')

@section('content')

<div class="row">

    <div class="col-lg-3">

        <h2 class="my-4">สินค้า</h2>
        <div class="form-group">
            <h4>เลือกประเภทสินค้า</h4> {{ Form::select('category_id', App\Category::all()->pluck('name',
                'id'), $cat_id, ['class' => 'form-control', 'placeholder' => 'กรุณาเลือกประเภทสินค้า...'
                , 'onchange' => 'SelCat(this.value)','style' => 'font-size:120%']) }}
        </div>
        {{-- <div class="list-group">
            @foreach ($categoryAll as $c)
            <a href="{{ route('welcome.show',['id'=>$c->id]) }}" class="list-group-item">{{$c->name}}</a>
        @endforeach
    </div> --}}

</div>
<!-- /.col-lg-3 -->

<div class="col-lg-9">

    <h1 class="my-4">{{$category->name}}</h1>

    <div class="row">

        @foreach ($category->products as $p)

        @php
        $stock_total = App\Stock::with('unit')->select('unit_id', DB::raw('SUM(total) as total_all'))
        ->groupBy('unit_id')->where('product_id', $p->id)->get();
        @endphp

        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100">
                {{-- <a href="#"><img class="card-img-top" src="{{asset('storage/images/'.$p->picture)}}"
                alt=""></a> --}}
                <a><img class="card-img-top" src="{{asset('../shopping/storage/app/public/images/'.$p->picture)}}"
                        alt=""></a>
                <div class="card-body">
                    <h4 class="card-title">
                        <a>{{$p->name}}</a>
                    </h4>
                    {{-- <h5>{{$p->price}}</h5> --}}

                </div>
                <div class="card-footer">
                    <div style="float: left; width: 50%">
                        คงเหลือ<br>
                        @foreach ($stock_total as $s)
                        @php
                            if($s->total_all <= 0){
                                $colorN = 'red';
                            }else if($s->total_all < 10){
                                $colorN = 'orangered';
                            }else if($s->total_all >= 10){
                                $colorN = 'blue';
                            }
                        @endphp
                        <span style="font-size:150%;color:{{$colorN}}">{{$s->total_all}}</span>
                        {{$s->unit->name}}
                        <br>
                        @endforeach
                        <br>
                    </div>
                    <div style="float: right; width: 50%">
                        <button class="btn btn-info float-sm-right" style="float: right;"
                            onclick="add2cart('{{$p->id}}','S')"><i class="fa fa-shopping-cart"
                                aria-hidden="true"></i></button>
                    </div>
                    {{-- จำนวน
                                    <input id="PQ{{$p->id}}" type="number" step="1" style="width: 50px;" value="1">
                    --}}
                    {{-- <a href="{{ route('cart.store',['product_id'=>$p->id,'newqty'=>'S','fn'=>'']) }}"
                    class="btn btn-info float-sm-right">หยิบใส่ตะกร้า</a> --}}
                </div>
            </div>
        </div>

        @endforeach

    </div>
    <!-- /.row -->

</div>
<!-- /.col-lg-9 -->
</div>
@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

<script>
    function add2cart(id,qty){
        //var idPQ = ;
        // var PQ = document.getElementById('PQ'+id).value;

        var url = '{{ route('cart.store',['product_id'=>':id','newqty'=>':qty']) }}';

        url = url.replace(':id', id);
        url = url.replace(':qty', '1');

        swal("{{session('feedback')}}","เพิ่มลงตะกร้าสินค้าเรียบร้อย","success");

        window.location.href=url;

        //alert(url);
    }
</script>
<script>
    function SelCat(cat_id){
    //alert(cat_id);
    var url = '{{ route('welcome.show',['id'=>':id']) }}';
        url = url.replace(':id', cat_id);

        window.location.href=url;
}
</script>
@endsection