@extends('layouts.frontend')

@section('content')

<div class="row my-4">
    <div class="col-md-12">
        <div class="card-header">
            <h3>ราคาสินค้า "{{ $product->name }}"</h3>
        </div>
        <div class="card">
            <div class="card-body">

                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <h5>ราคากลางสินค้า</h5>
                <div>

                    {{-- <a href="{{route ('price.createP',['product_id'=>$product->id])}}" class="btn btn-primary
                    btn-lg">เพิ่มราคาสินค้า</a> --}}

                    {{-- <h5>ราคาสินค้า </h5> --}}
                    @if (count($priceMid) > 0)

                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">หน่วย</th>
                                <th scope="col">ราคา/หน่วย</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($priceMid as $p)
                            <tr>
                                <td>{{$p->unit}}</td>
                                <td>{{number_format($p->price,2)}}</td>
                            </tr>
                            @endforeach

                        </tbody>
                    </table>
                    <br>
                    @else

                    <p class="mt-4">--- ยังไม่มีราคาสินค้า ---</p>

                    @endif
                </div>

                <h5>เพิ่ม ราคาสินค้า "<span style="color:blue;font-size:120%">{{$address->name}}</span>"</h5>

                {!! Form::open(['novalidate','route' => 'price.setname', 'method' => 'post','class'=>
                ($errors->any()) ? 'was-validated' : 'needs-validation']) !!}
                {{-- <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}"
                method="post"
                enctype="multipart/form-data"
                action="{{ route('product.store') }}">
                @csrf --}}

                <div>
                    <div class="form-inline">

                        <div class="form-inline mt-3 mr-3" hidden>
                            <label for="exampleFormControlInput1">product id : </label> {{ Form::text('product_id', $product->id,['class'=>'form-control ',
                                                                    'required']) }}
                            @if ($errors->has('product_id'))
                            <div class="invalid-feedback">{{ $errors->first('product_id') }}</div>
                            @endif

                        </div>

                        <div class="form-inline mt-3 mr-3" hidden>
                            <label for="exampleFormControlInput1">address id : </label> {{ Form::text('address_id', $address->id,['class'=>'form-control ',
                                                            'required']) }}
                            @if ($errors->has('address_id'))
                            <div class="invalid-feedback">{{ $errors->first('address_id') }}</div>
                            @endif

                        </div>

                        <div class="form-inline mt-3 mr-3">
                            <label for="exampleFormControlInput1">ชื่อสินค้า : </label> {{ Form::text('product_name'
                                , $productN ,['class'=>'form-control ','required']) }}
                            @if ($errors->has('product_name'))
                            <div class="invalid-feedback">{{ $errors->first('product_name') }}</div>
                            @endif

                        </div>
                        <button type="submit" class="btn btn-warning mt-3">เปลี่ยนชื่อสินค้า</button>
                    </div>

                </div>

                </form>

                {!! Form::open(['novalidate','route' => 'price.store', 'method' => 'post','class'=>
                ($errors->any()) ? 'was-validated' : 'needs-validation']) !!}
                {{-- <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}"
                method="post"
                enctype="multipart/form-data"
                action="{{ route('product.store') }}">
                @csrf --}}

                <div class="form-inline">

                    <div class="form-inline mt-3 mr-3" hidden>
                        <label for="exampleFormControlInput1">product id : </label> {{ Form::text('product_id', $product->id,['class'=>'form-control ',
                                                            'required']) }}
                        @if ($errors->has('product_id'))
                        <div class="invalid-feedback">{{ $errors->first('product_id') }}</div>
                        @endif

                    </div>

                    <div class="form-inline mt-3 mr-3" hidden>
                        <label for="exampleFormControlInput1">address id : </label> {{ Form::text('address_id', $address->id,['class'=>'form-control ',
                                                    'required']) }}
                        @if ($errors->has('address_id'))
                        <div class="invalid-feedback">{{ $errors->first('address_id') }}</div>
                        @endif

                    </div>

                    <div class="form-inline mt-3 mr-3">
                        <label for="exampleFormControlInput1">หน่วย : </label> {{ Form::text('unit', null,['class'=>'form-control ',
                                            'required']) }}
                        @if ($errors->has('unit'))
                        <div class="invalid-feedback">{{ $errors->first('unit') }}</div>
                        @endif

                    </div>

                    <div class="form-inline mt-3 mr-3">
                        <label for="exampleFormControlInput1">ราคาต่อหน่วย :</label> {{ Form::text('price', null,['class'=>'form-control ',
                                        'required']) }}
                        @if ($errors->has('price'))
                        <div class="invalid-feedback">{{ $errors->first('price') }}</div>
                        @endif

                    </div>

                    <button type="submit" class="btn btn-success mt-3">เพิ่ม</button>

                </div>

                </form>


            </div>
            <div class="card-body">

                {{-- <a href="{{route ('price.createP',['product_id'=>$product->id])}}" class="btn btn-primary
                btn-lg">เพิ่มราคาสินค้า</a> --}}

                {{-- <h5>ราคาสินค้า </h5> --}}
                @if (count($price) > 0)

                <table class="table">
                    <thead>
                        <tr>
                            <th scope="col">หน่วย</th>
                            <th scope="col">ราคา/หน่วย</th>
                            <th scope="col">เครื่องมือ</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($price as $p)
                        <tr>
                            <td>{{$p->unit}}</td>
                            <td>{{number_format($p->price,2)}}</td>
                            <td>
                                <a href="{{ route('price.edit',['id'=>$p->id]) }}"
                                    class="btn btn-info btn-sm d-inline mr-2">
                                    <li class="fa fa-pencil text-white">

                                    </li>
                                </a>
                                <form method="POST" action="{{ route('price.destroy',['id'=>$p->id]) }}"
                                    class="d-inline" onsubmit="return confirm('คุณต้องการลบข้อมูลใช่ หรือไม่?')">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-danger btn-sm">
                                        <li class="fa fa-trash text-white"></li>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
                <br>
                {{$price->links()}}

                @else

                <p class="mt-4">--- ยังไม่มีราคาสินค้า ---</p>

                @endif
            </div>
        </div>
        <a href="{{ route('cart.cartsale',['address_id'=>$address->id]) }}">
            <button type="button" class="btn btn-primary">กลับ</button>
        </a>
    </div>
</div>

@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

@endsection
