@extends('layouts.frontend')

@section('content')

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h3>ออเดอร์ของฉัน</h3>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">วันที่</th>
                                <th scope="col">ชื่อผู้รับ</th>
                                <th scope="col">รายการสินค้า</th>
                                <th scope="col">ยอดเงิน(บาท)</th>
                                <th scope="col">สถานะ</th>
                                <th scope="col">เครื่องมือ</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($listOrder as $o)

                            <tr>
                                <td>
                                    @if ($o->created_at != "")
                                    @foreach(explode(' ', $o->created_at) as $date)
                                    @if($loop->first)
                                    {{$date}}
                                    @endif
                                    @endforeach
                                    @endif
                                </td>
                                <td>{{ $o->address->name }}</td>
                                <td>
                                    @php
                                        $i = 0;
                                    @endphp
                                    @if ($o->detail != "")
                                    @foreach(explode('|', $o->detail) as $product)
                                    @php
                                    $product_Detail = explode(":",$product);
                                    $product_Name = $product_Detail[0];
                                    $product_Qty = $product_Detail[1];
                                    $product_Price = $product_Detail[2];
                                    $product_Total = $product_Detail[3];
                                    @endphp
                                    <a href="{{ '#' }}" rel="tooltip" title="{{$product_Name}}">
                                        {{str_limit($product_Name,35)}}</a><br>
                                    <span style="font-size:80%">{{ $product_Qty }} หน่วย ราคา/หน่วย {{ $product_Price }} รวม {{ number_format($product_Total,2) }} บาท</span> <br>
                                    @endforeach
                                    @endif
                                </td>
                                <td>{{number_format($o->total,2)}}</td>
                                <td>
                                    @if($o->invoice_id=='1')
                                    กำลังดำเนินการ
                                    @else

                                    @endif
                                </td>
                                <td>
                                    <form method="POST" action="{{ route('order.destroy',['id'=>$o->id]) }}"
                                        class="d-inline" onsubmit="return confirm('คุณต้องการลบข้อมูลใช่ หรือไม่?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-danger btn-sm">
                                            ยกเลิก
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <br>
                </div>
            </div>
        </div>


    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->
@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

<script type="text/javascript">
	$(document).ready(function(){
	    $("[rel=tooltip]").tooltip({ placement: 'top'});
	});
</script>

@endsection
