@extends('layouts.frontend')

@section('content')

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h3>ออเดอร์ของฉัน</h3>
                </div>
                <div class="card-body" style="overflow-x:auto;">
                    <table class="table text-nowrap">
                        <thead>
                            <tr>
                                <th scope="col">เลขที่</th>
                                <th scope="col">วันที่</th>
                                <th scope="col">ชื่อผู้รับ</th>
                                <th scope="col">รายการสินค้า</th>
                                <th scope="col">ยอดเงิน(บาท)</th>
                                <th scope="col">สถานะ</th>
                                <th scope="col">เครื่องมือ</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($listOrder as $indexKey => $o)

                            <tr>
                                <td>
                                    @if($o->myordercode=='')
                                    -
                                    @else
                                    {{$o->myordercode->code}}
                                    @endif
                                </td>
                                <td>
                                    @if ($o->created_at != "")
                                    @foreach(explode(' ', $o->created_at) as $date)
                                    @if($loop->first)
                                    {{$date}}
                                    @endif
                                    @endforeach
                                    @endif
                                </td>
                                <td>{{$o->address_name}}</td>
                                <td>
                                    @php
                                    $chkIV = '';
                                    @endphp
                                    @foreach($listOrder[$indexKey++]->orders as $p)
                                    <a href="{{ '#' }}" rel="tooltip" title="{{$p->product_name}}"
                                        onclick="showProductDetail('{{$p->product_id}}')" data-toggle="modal"
                                        data-target="#myProduct">
                                        {{str_limit($p->product_name,35)}}</a><br>
                                    <span style="font-size:80%">จำนวน {{$p->qty.' '.$p->unit_name}}
                                        {{' '.$p->unit_name.'ละ '.$p->price_now.' บาท '}}<br>
                                        {{ 'รวม '.number_format($p->total,2).' บาท'}}</span>
                                    <br>
                                    @php
                                    if($p->invoice_id == '0'){
                                    $chkIV = 'wait';
                                    }
                                    elseif($p->invoice_id == '1'){
                                    $chkIV = 'confirm';
                                    }
                                    elseif ($p->invoice_id != '0' && $p->invoice_id != '1') {
                                    if($chkIV == 'wait' || $chkIV == 'some'|| $chkIV == 'confirm'){
                                    $chkIV = 'some';
                                    }
                                    else {
                                    $chkIV = 'ok';
                                    }
                                    }
                                    @endphp
                                    @endforeach
                                    @php
                                    if($chkIV=='wait'){
                                    $showStatus = 'กำลังดำเนินการ';
                                    }
                                    elseif($chkIV=='confirm'){
                                    $showStatus = 'ยืนยันคำสั้งซื้อ';
                                    }
                                    elseif($chkIV=='some'){
                                    $showStatus = 'ค้างส่งสินค้า';
                                    }
                                    elseif($chkIV=='ok'){
                                    $showStatus = 'ส่งสินค้าเรียบร้อย';
                                    }
                                    $status[$indexKey] = $showStatus;
                                    @endphp
                                </td>
                                <td>{{number_format($o->total,2)}}</td>
                                <td>
                                    {{$status[$indexKey]}}
                                </td>
                                <td>
                                    <button class="btn btn-success btn-sm">
                                        <a href="{{route('print.export',['order_id'=>$o->id])}}" target="_blank">
                                            <i class="fa fa-file-pdf-o text-white"></i>
                                        </a>
                                    </button>
                                    @if($status[$indexKey]=='กำลังดำเนินการ')
                                    <button class="btn btn-primary btn-sm" onclick="confirm_edit('{{$o->id}}')">
                                        แก้ไข
                                    </button>
                                    <form method="POST" action="{{ route('myorder.destroy',['id'=>$o->id]) }}"
                                        class="d-inline"
                                        onsubmit="return confirm('คุณต้องการยกเลิกรายการสั่งซื้อใช่ หรือไม่?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-danger btn-sm">
                                            ยกเลิก
                                        </button>
                                    </form>
                                    @else
                                    <button class="btn btn-danger btn-sm" disabled>
                                        ยกเลิก
                                    </button>
                                    @endif
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <br>
                    {{$listOrder->links()}}
                </div>
            </div>
        </div>


    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->

{{-- //return confirm('are you sure?');
//window.location='{{ route('myorder.reuse',['id'=>$o->id]) }}'; --}}

@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

<script type="text/javascript">
    $(document).ready(function(){
	    $("[rel=tooltip]").tooltip({ placement: 'top'});
	});
</script>
<script>
    function confirm_edit(order_id) {
  swal({
  title: "คุณต้องการแก้ไขข้อมูล ใช่หรือไม่?",
  text: "ออเดอร์ของคุณจะถูกส่งกลับไปยังตะกร้าสินค้า",
  icon: "warning",
  buttons: true,
  dangerMode: true,
})
.then((willDelete) => {
  if (willDelete) {
    var url = '{{ route('myorder.reuse',['id'=>':id']) }}';
    url = url.replace(':id',order_id);
    window.location = url;
  } else {
  }
});
}
</script>

@endsection