@extends('layouts.backend')

@section('content')

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h3>คำสั่งซื้อ (ยืนยันคำสั่งซื้อแล้ว)</h3>
                </div>
                <div class="card-body" style="overflow-x: auto;">
                    <table class="table text-nowrap">
                        <thead>
                            <tr>
                                <th scope="col">เลขที่</th>
                                <th scope="col">วันที่</th>
                                <th scope="col">ชื่อผู้รับ</th>
                                <th scope="col">รายการสินค้า</th>
                                <th scope="col">ยอดเงิน(บาท)</th>
                                <th scope="col">พนักงานขาย</th>
                                <th scope="col">หมายเหตุ</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($listOrder as $indexKey => $o)

                            <tr>
                                <td>
                                    @if($o->myordercode=='')
                                    -
                                    @else
                                    {{$o->myordercode->code}}
                                    @endif
                                </td>
                                <td>
                                    @if ($o->created_at != "")
                                    @foreach(explode(' ', $o->created_at) as $date)
                                    @if($loop->first)
                                    {{$date}}
                                    @endif
                                    @endforeach
                                    @endif
                                </td>
                                <td>{{$o->address_name}}</td>
                                <td>
                                    @foreach($listOrder[$indexKey++]->orders as $p)
                                    <a href="{{ '#' }}" rel="tooltip" title="{{$p->product_name}}"
                                        onclick="showProductDetail('{{$p->product_id}}')" data-toggle="modal"
                                        data-target="#myProduct">
                                        {{str_limit($p->product_name,35)}}</a><br>
                                    <span style="font-size:80%">จำนวน {{$p->qty.' '.$p->unit_name}}
                                        {{' '.$p->unit_name.'ละ '.$p->price_now.' บาท '}}
                                        {{ 'รวม '.number_format($p->total,2).' บาท'}}</span>
                                    <br>
                                    @endforeach
                                </td>
                                <td>{{number_format($o->total,2)}}</td>
                                <td>
                                    {{$o->user->name}}
                                </td>
                                <td>
                                    @if($o->remark=='')
                                    -
                                    @else
                                    <a href="#" rel="tooltip" title="{{$o->remark}}">{...}</a>
                                    @endif
                                </td>
                                <td>
                                    <button class="btn btn-success btn-sm">
                                        <a href="{{route('print.export',['order_id'=>$o->id])}}" target="_blank">
                                            <i class="fa fa-file-pdf-o text-white"></i>
                                        </a>
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <br>
                    {{$listOrder->links()}}
                </div>
            </div>
        </div>


    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->
@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif
@if(session('feedback_error'))
<script>
    swal("{{session('feedback_error')}}","ผลการทำงาน","error");
</script>
@endif
@if(session('feedback_W'))
<script>
    swal("{{session('feedback_W')}}","{{session('feedback_Ws')}}","warning");
</script>
@endif

<script type="text/javascript">
    $(document).ready(function(){
	    $("[rel=tooltip]").tooltip({ placement: 'top'});
	});
</script>

<script>
    function ComfirmOrder(order_id) {
  swal({
  title: "คุณต้องการยืนยันคำสั่งซื้อ ใช่หรือไม่?",
  text: "กรุณารายการสินค้า และราคาสินค้าให้ถูกต้อง",
  icon: "warning",
  buttons: true,
  dangerMode: true,
})
.then((willDelete) => {
  if (willDelete) {
    var url = '{{ route('invoice.confirm',['id'=>':id']) }}';
    url = url.replace(':id',order_id);
    window.location = url;
  } else {
  }
});
}
</script>
@endsection
