@extends('layouts.frontend')
@section('content')

<div class="row my-4">
    <!-- /.col-lg-3 -->

    <div class="col-lg-12">

        <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}" method="post"
            enctype="multipart/form-data" action="{{ route('order.confirm') }}">
            @csrf

            <h3>ทำการสั่งซื้อ</h3>

            <br>
            <h5>ที่อยู่ในการจัดส่ง</h5>
            <input type="number" name="address_id" value="{{ $address->id }}" hidden>
            <div class="card">
                <table class="table table-hover shopping-cart-wrap">
                    <thead class="text-muted">
                        <tr>
                            <th scope="col">ชื่อ</th>
                            <th scope="col">ที่อยู่</th>
                            <th scope="col">เบอร์โทรศัพท์</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>
                                <figure class="media">
                                    <figcaption class="media-body">
                                        <h6 class="title text-truncate">{{ $address->name }}</h6>
                                    </figcaption>
                                </figure>
                            </td>
                            <td>
                                <figure class="media">
                                    <figcaption class="media-body">
                                        <p class="title text-truncate">
                                            {{$address->address}}<br>
                                            {{'ตำบล/แขวง : '.$address->sub_district}}<br>
                                            {{' อำเภอ/เขต : '.$address->district}}<br>
                                            {{'จังหวัด : '.$address->province}}<br>
                                            {{' รหัสไปรษณีย์ : '.$address->zipcode}}
                                        </p>
                                    </figcaption>
                                </figure>
                            </td>
                            <td>
                                <figure class="media">
                                    <figcaption class="media-body">
                                        <h6 class="title text-truncate">{{$address->tel}}</h6>
                                    </figcaption>
                                </figure>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <h5>รายการสินค้า</h5>

            @if (count($listCart) > 0)
            <div class="card">
                <table class="table table-hover shopping-cart-wrap">
                    <thead class="text-muted">
                        <tr>
                            <th>#</th>
                            <th scope="col">ชื่อสินค้า</th>
                            <th scope="col" width="120">จำนวน</th>
                            <th scope="col" width="120">ราคาต่อชิ้น</th>
                            <th scope="col" width="120">ราคา</th>
                        </tr>
                    </thead>
                    <tbody>

                        <p style="display:none">{{ $sumAll = 0}}</p>
                        @foreach ($listCart as $indexKey => $cart)
                        <p style="display:none">{{$sumAll += ($cart->price)*($cart->pivot->qty)}}</p>
                        <tr>
                            <td><input type="checkbox" name="product_id[]" value="{{ $cart->id }}" checked="checked"
                                    style='display:none;'> {{ ++$indexKey }}</td>
                            <td>
                                <figure class="media">
                                    <figcaption class="media-body">
                                        <h6 class="title text-truncate">{{ $cart->name }}</h6>
                                    </figcaption>
                                </figure>
                            </td>
                            <td>

                                {{ $cart->pivot->qty }}

                            </td>
                            <td>
                                <div class="price-wrap">
                                    <var id="priceT{{ $indexKey }}" class="price">{{ $cart->price }}</var>
                                </div>
                                <!-- price-wrap .// -->
                            </td>
                            <td>
                                <div class="price-wrap">
                                    <var id="totalT{{ $indexKey }}" class="price">
                                        {{ number_format(($cart->price)*($cart->pivot->qty),2) }}</var>
                                </div>
                                <!-- price-wrap .// -->
                            </td>
                        </tr>
                        @endforeach
                        <tr class="table-active">
                            <td></td>
                            <td></td>
                            <td><span id="Qsum" style="font-size:150%">{{ $sumQty }}</span> ชิ้น</td>
                            <td></td>
                            <td>
                                <span style="font-size:150%" id="Tsum">{{ number_format($sumAll,2) }}</span>
                            </td>
                            <td><span>บาท</span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- card.// -->

            {{-- Hidden Object --}}

            <input type="number" name="total" value="{{ $sumAll }}" hidden>

            {{-- END Hidden Object --}}

            <h5>หมายเหตุ</h5>
            <div class="card">
                <div class="my-2 mx-2">
                    {!! Form::textarea('remark',$remark,['class'=>'form-control', 'rows' => 3, 'cols' => 40]) !!}
                </div>
            </div>

            <div class="text-right">
                {{-- <a href="{{ route('cart.confirm') }}" class="btn btn-primary btn-lg">ยืนยันการสั่งซื้อ</a> --}}
                {{-- <a href="{{ route('cart.checkout') }}" class="btn btn-primary btn-lg">ยืนยันการสั่งซื้อ</a> --}}
                <button type="button" class="btn btn-danger mt-3" onclick="G2Cart()">ยกเลิก</button>
                <button type="submit" class="btn btn-primary mt-3">ยืนยันคำสั่งซื้อ</button>
            </div>


        </form>

        @else

        <p>--- ยังไม่ได้เลือกสินค้า ---</p>

        @endif


    </div>
    <!-- /.col-lg-9 -->

</div>
<!-- /.row -->
@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

<script>
    function testF(){
    document.getElementById('testSS').innerHTML = '555';
}
</script>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js"></script>

<script>
function G2Cart(){
    window.location.href = '{{ route('cart.index') }}';
    //alert('5555');
}
</script>

@endsection
