<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{config('app.name')}}</title>

    <!-- Bootstrap core CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="{{asset('css/app.css')}}" rel="stylesheet">

    <!-- Custom styles for this template -->
    <link href="{{asset('css/theme.css')}}" rel="stylesheet">
    {{-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-alpha.6/css/bootstrap.min.css" integrity="sha384-rwoIResjU2yc3z8GV/NPeZWAv56rSmLldC3R/AZzGRnGxQQKnKkoFVhFQhNUwEyJ" crossorigin="anonymous"> --}}

</head>

<body>

    <div id="app">

        <!-- Navigation -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-success fixed-top">
            <div class="container">
                <a class="navbar-brand" href="{{route('welcome')}}">
                    <img src="{{asset('../shopping/storage/app/public/images/LogoDiag.png')}}" alt="" width="130" height="36"> </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarResponsive"
                    aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarResponsive">
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item {{ request()->routeIs('welcome') ? 'bg-light':'' }}">
                            <a class="nav-link" href="{{route('welcome')}}">หน้าหลัก
                                <span class="sr-only">(current)</span>
                            </a>
                        </li>
                        <li class="nav-item {{ request()->routeIs('about') ? 'bg-light':'' }}">
                            <a class="nav-link" href="{{route('about')}}">เกี่ยวกับเรา</a>
                        </li>

                        @auth
                        <li class="nav-item {{ request()->routeIs('cart.index') ? 'bg-light':'' }}">
                            <a class="nav-link" href="{{ route('cart.index') }}">
                                ตะกร้าสินค้า
                                <span class="badge badge-warning">
                                    {{ App\Cart::where('user_id',auth()->user()->id)->count('product_id') }}
                                </span>
                            </a>
                        </li>
                        @endauth

                        <li class="nav-item {{ request()->routeIs('contact.index') ? 'bg-light':'' }}">
                            <a class="nav-link" href="{{route('contact.index')}}">ติดต่อเรา</a>
                        </li>

                        {{-- <li class="nav-item {{ request()->routeIs('welcome.category') ? 'bg-light':'' }}">
                            <a class="nav-link" href="{{route('welcome.category')}}">ประเภทสินค้า(vue.js)</a>
                        </li> --}}
                        @guest
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">เข้าสู่ระบบ</a>
                        </li>
                        @if (Route::has('register'))
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('register') }}">ลงทะเบียน</a>
                        </li>
                        @endif
                        @else
                        <li class="nav-item dropdown">
                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                welcome {{ Auth::user()->name }} <span class="caret"></span>
                            </a>

                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">

                                {{-- <a class="dropdown-item bg-primary" href="{{ route('order') }}">
                                คำสั่งซื้อ
                                </a> --}}
                                <a class="dropdown-item bg-success" href="{{ route('address.index') }}" style="color: green;">
                                    ที่อยู่ของฉัน
                                </a>

                                <a class="dropdown-item bg-success" href="{{ route('myorder.index') }}" style="color: green;">
                                    ออเดอร์ของฉัน
                                </a>

                                @role('Admin')
                                <a class="dropdown-item bg-success" href="{{ route('dashboard') }}">
                                    Dashboard
                                </a>
                                @endrole

                                <a class="dropdown-item bg-danger" href="{{ route('logout') }}" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                    {{ __('Logout') }}
                                </a>

                                <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                    style="display: none;">
                                    @csrf
                                </form>
                            </div>
                        </li>
                        @endguest
                    </ul>
                </div>
            </div>
        </nav>

        <!-- Page Content -->
        <div class="container">

            @yield('content')

        </div>
        <!-- /.container -->

        <!-- Footer -->
        @include('partials.footer')
        {{-- Show Product --}}
    </div>
    @include('partials.showproduct')
    <!-- Bootstrap core JavaScript -->
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="{{ asset('../shopping/node_modules/moment/moment.js') }}"></script>
    <script src="{{ asset('../shopping/node_modules/chart.js/dist/Chart.js') }}"></script>
    @yield('footerscript')

</body>

</html>
