<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Dashboard {{config('app.name')}}</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">

</head>

<body class="hold-transition sidebar-mini">
    <div id="app" class="wrapper">

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand bg-white navbar-light border-bottom">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#"><i class="fa fa-bars"></i></a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a href="{{ route('dashboard') }}" class="nav-link">หน้าหลัก</a>
                </li>
                <li class="nav-item d-sm-inline-block text-nowrap">
                    <a href="{{route('welcome')}}" class="nav-link">ซื้อสินค้า</a>
                </li>
                <li class="nav-item d-sm-inline-block">
                    <a href="{{route('stock.index')}}" class="nav-link">Stock</a>
                </li>
            </ul>
            <!-- Right navbar links -->
            <ul class="navbar-nav ml-auto">
                <li class="nav-item d-sm-inline-block bg-warning">
                    <a class="nav-link" href="{{ route('logout') }}" onclick="event.preventDefault();
                              document.getElementById('logout-form').submit();">
                        ออกจากระบบ
                    </a>

                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                        @csrf
                    </form>
                </li>
            </ul>

        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="{{ route('dashboard') }}" class="brand-link">
                <img src="{{ asset('img/logo.png') }}" alt="Logo" class="brand-image img-circle elevation-3"
                    style="opacity: .8">
                <span class="brand-text font-weight-light">{{config('app.name')}}</span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar user panel (optional) -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        {{-- <img src="dist/img/user2-160x160.jpg" class="img-circle elevation-2" alt="User Image"> --}}
                    </div>
                    <div class="info">
                        <a href="#" class="d-block">Hello, {{ auth()->user()->name }}</a>
                        <small class="text-light">
                            ที่อยู่ : {{optional(auth()->user()->profile)->address}}
                        </small>
                        <br>
                        <small class="text-light">
                            อีเมล์ : {{ auth()->user()->email }}
                            <br>
                            บทบาท : {{ auth()->user()->getRoleNames()[0] }}
                            {{-- อีเมล์ {{App\profile::where('user_id',auth()->user()->id)->first()->user->email}} --}}
                        </small>
                    </div>
                </div>

                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">

                        <li class="nav-header">ข้อมูลหลัก</li>

                        @role('Admin')
                        <li class="nav-item">
                            <a href="{{route('category.index')}}" class="nav-link">
                                <i class="nav-icon fa fa-th-large"></i>
                                <span class="brand-text font-weight-light"
                                    style="display: inline-block">ประเภทสินค้า</span>
                            </a>
                        </li>

                        {{-- Datatables --}}
                        {{-- <li class="nav-item">
                            <a href="{{route('category.catagory2')}}" class="nav-link">
                        <i class="nav-icon fa fa-th-large"></i>
                        <span class="brand-text font-weight-light" style="display: inline-block">ประเภทสินค้า
                            table</span>
                        </a>
                        </li> --}}
                        @endrole

                        {{-- <li class="nav-item has-treeview">
                            <a href="{{route('product.index')}}" class="nav-link">
                        <i class="nav-icon fa fa-cubes"></i>
                        <span class="brand-text font-weight-light">สินค้า</span>
                        </a>
                        </li> --}}

                        <li class="nav-item has-treeview">
                            <a href="{{route('product.index2')}}" class="nav-link">
                                <i class="nav-icon fa fa-cubes"></i>
                                <span class="brand-text font-weight-light">สินค้า</span>
                            </a>
                        </li>

                        <li class="nav-item has-treeview">
                            <a href="{{route('price.index')}}" class="nav-link">
                                <i class="nav-icon fa fa-table"></i>
                                <span class="brand-text font-weight-light">ราคาสินค้า</span>
                            </a>
                        </li>

                        <li class="nav-item has-treeview">
                            <a href="{{route('myorder.confirmed')}}" class="nav-link">
                                <i class="nav-icon fa fa-check-square-o"></i>
                                <span class="brand-text font-weight-light">คำสั่งซื้อที่ยืนยันแล้ว</span>
                            </a>
                        </li>


                        {{-- <li class="nav-item has-treeview">
                            <a href="{{route('print.export',['order_id'=>'4'])}}" class="nav-link">
                                <i class="nav-icon fa fa-table"></i>
                                <span class="brand-text font-weight-light">test_print</span>
                            </a>
                        </li> --}}

                    </ul>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            @yield('content')
        </div>
        <!-- /.content-wrapper -->
        <footer class="main-footer">
            <strong>Copyright &copy; {{date('Y')}} <a href="http://adminlte.io">AdminLTE.io</a>.</strong> All rights
            reserved.
            <div class="float-right d-none d-sm-inline-block">
                <b>Version</b> 1.0
        </footer>

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->
    </div>
    <!-- ./wrapper -->

    {{-- Show Product --}}
    @include('partials.showproduct')

    <script src="{{ asset('js/app.js') }}"></script>
    <script src="{{ asset('../shopping/node_modules/moment/moment.js') }}"></script>
    <script src="{{ asset('../shopping/node_modules/chart.js/dist/Chart.js') }}"></script>

    @yield('footerscript')

</body>

</html>
