@extends('layouts.frontend')
@section('content')

<div class="row my-4">
    <!-- /.col-lg-3 -->

    <div class="col-lg-12">

        <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}" method="post"
            enctype="multipart/form-data" action="{{ route('myorder.store') }}">
            @csrf

            @if (count($listCart) > 0)
            <h4>ที่อยู่</h4>

            @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <div class="card">
                <div class="form-group container">
                    <label for="exampleFormControlSelect1"></label>
                    {{ Form::select('address_id', App\Address::where('user_id', auth()->user()->id)->pluck('name',
                                    'id'), null, ['class' => 'selectpicker form-control dynamic', 'placeholder' => 'กรุณาเลือกที่อยู่...'
                                    , 'required','data-live-search="true"','id'=>'SelAddress','onchange'=>'testS(this.value)']) }}
                    @if ($errors->has('address_id'))
                    <div class="invalid-feedback">{{ $errors->first('address_id') }}</div>
                    @endif
                    <div class="my-2 text-right"><a href="{{ route ('address.index') }}">จัดการที่อยู่</a></div>
                    <div id="testSS" class="text-nowrap" style="overflow-x:auto;"></div>
                </div>
            </div>

            <h5>เลขที่ใบสั่งซื้อ (ถ้ามี)</h5>
            <div class="card">
                <div class="my-2 mx-2">
                    {{ Form::text('customer_po', null,['class'=>'form-control ']) }}
                </div>
            </div>

            <h4>ตะกร้าสินค้า</h4>
            <div class="card" style="overflow-x:auto;">
                <table class="table table-hover shopping-cart-wrap text-nowrap">
                    <thead class="text-muted">
                        <tr>
                            <th>#</th>
                            <th scope="col">ชื่อสินค้า</th>
                            <th scope="col">จำนวน</th>
                            <th scope="col">หน่วย</th>
                            <th scope="col">ราคาต่อหน่วย</th>
                            <th scope="col">ราคารวม</th>
                            <th scope="col" class="text-right"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <p style="display:none">{{ $sumAll = 0}}</p>
                        @foreach ($listCart as $indexKey => $cart)
                        <p style="display:none">{{$sumAll += ($cart->price)*($cart->pivot->qty)}}</p>
                        <tr>
                            {{-- <td>{{ ++$indexKey }}</td> --}}
                            <td><input type="checkbox" id="cbT{{++$indexKey}}" name="checkbox[]"
                                    value="{{ $cart->id.':'.($indexKey-1) }}" onchange="sumAll()" checked="checked">
                            </td>
                            <td>
                                <figure class="media">
                                    <figcaption class="media-body">
                                        <h6 class="title text-truncate" id="nameT{{ $indexKey }}">{{ $cart->name }}</h6>
                                    </figcaption>
                                </figure>
                            </td>
                            <td>
                                <input id="qtyT{{$indexKey}}" name="qty[]" type="number" value="{{ $cart->pivot->qty }}"
                                    min="0" max="10000" step="1" onchange="sumAll()" />
                            </td>
                            {{-- onchange="sumPrice({{ $indexKey }},{{$cart->id}})" --}}
                            @if (count($cart->prices) > 0)
                            <td>

                                {{-- @foreach ($cart->prices as $indexPrice => $price) --}}

                                {{ Form::select('unit[]', $cart->prices->pluck('unit',
                                'id'), null, ['class' => 'form-control selPrice', 'required', 'placeholder' => 'เลือก'
                                ,'onchange'=>'getPrice(this.value,'.$indexKey.')']) }}
                                @if ($errors->has('unit[]'))
                                <div class="invalid-feedback">{{ $errors->first('unit[]') }}</div>
                                @endif

                                {{-- @endforeach --}}

                            </td>
                            @else
                            <td>
                                <p>ไม่มีราคาสินค้า</p>
                            </td>
                            @endif
                            <td>
                                <div class="price-wrap">
                                    <var id="priceT{{ $indexKey }}" class="price">0</var>
                                </div>
                                <!-- price-wrap .// -->
                            </td>
                            <td>
                                <div class="price-wrap">
                                    <var id="totalT{{ $indexKey }}" class="price">0</var>
                                </div>
                                <!-- price-wrap .// -->
                            </td>

                            <td class="text-right">
                                @if ( isset($address_id) ? $address_id : '' )
                                @if ( $address_id != '' )
                                <a href="{{ route('cart.pricesale',['product_id'=>$cart->id,'address_id'=>$address_id]) }}"
                                    class="btn btn-outline-success">
                                    ราคา</a>
                                @endif
                                @endif
                                <a href="{{ route('cart.delete',['product'=>$cart->id]) }}"
                                    class="btn btn-outline-danger">
                                    × ลบ</a>
                            </td>

                        </tr>
                        @endforeach
                        <tr class="table-active">
                            <td></td>
                            <td></td>
                            {{-- <td><span id="Qsum" style="font-size:150%">{{ $sumQty }}</span> ชิ้น</td> --}}
                            <td></td>
                            <td></td>
                            <td></td>
                            <td>
                                <input id="TsumS" name="sum" type="number" value="0" min="0" step="1" hidden />
                                <span id="Tsum" style="font-size:150%">0</span>
                            </td>
                            <td><span>บาท</span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- card.// -->
            <h4>หมายเหตุ</h4>
            <div class="card">
                <div class="my-2 mx-2">
                    {!! Form::textarea('remark',null,['class'=>'form-control', 'rows' => 3, 'cols' => 40]) !!}
                </div>
            </div>

            <div class="text-right">
                {{-- <a href="{{ route('cart.confirm') }}" class="btn btn-primary btn-lg">ยืนยันการสั่งซื้อ</a> --}}
                {{-- <a href="{{ route('cart.checkout') }}" class="btn btn-primary btn-lg">ยืนยันการสั่งซื้อ</a> --}}
                <button type="submit" class="btn btn-primary mt-3">สั่งสินค้า</button>
            </div>

        </form>

        @else

        <p>--- ยังไม่ได้เลือกสินค้า ---</p>

        @endif


    </div>
    <!-- /.col-lg-9 -->

</div>
<!-- /.row -->
@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

@if(session('feedback2'))
<script>
    swal("{{session('feedback2')}}","...","{{session('icon')}}");
</script>
@endif

<script>
    // function sumPrice(id,idC){
    //     var IDq = "qtyT"+id;
    //     var IDp = "priceT"+id;
    //     var IDt = "totalT"+id;
    //     var qty = document.getElementById(IDq).value;
    //     var price = document.getElementById(IDp).innerHTML;

    //     document.getElementById(IDt).innerHTML = '฿ '+(qty*price).toFixed(2);

    //     // var url = '{{ route('cart.store',['product_id'=>':id','newqty'=>':qty']) }}';

    //     // url = url.replace(':id', idC);
    //     // url = url.replace(':qty', qty);

    //     // window.location.href=url;

    //     sumAll();
    // }

    function sumAll(){

        var Allq = 0,Allp = 0;
        for(i = 1; i <= {{ isset($indexKey) ? $indexKey : '1' }}; i++){
                var cb = 'cbT'+i;
                var cbE = document.getElementById(cb);
                var idQty = "qtyT"+i;
                var idTotal = "totalT"+i;
                var idPrice = "priceT"+i;

                var qty = document.getElementById(idQty).value;
                var price = document.getElementById(idPrice).innerHTML;
                document.getElementById(idTotal).innerHTML
                    = (price*qty).toLocaleString('en', { minimumFractionDigits: 2 });

                if (cbE.checked == true){
                    var qtyS = document.getElementById(idQty).value;
                    var totalS = document.getElementById(idTotal).innerHTML;
                    // Allq += parseInt(qtyS);
                    Allp += parseFloat(totalS.replace(/,/g, ''));
                }

            }
        // document.getElementById('Qsum').innerHTML = Allq;

        document.getElementById('Tsum').innerHTML = Allp.toLocaleString('en', { minimumFractionDigits: 2 });
        document.getElementById('TsumS').value = Allp;
    }
</script>

<!-- Latest compiled and minified CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/css/bootstrap-select.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/js/bootstrap-select.min.js"></script>

<script>
    $('select').selectpicker();

    $(document).ready(function(){
    $('.dynamic').change(function(){

        if($(this).val() != '')
        {
        var value = $(this).val();
        var url = '{{ route('cart.cartsale',['address_id'=>':id']) }}';

        url = url.replace(':id', value);

        window.location.href=url;

        //alert(url);
        }
    });
});
</script>
<script>
    function getPrice(uid,rowid){

        var idPname= 'nameT'+rowid;
        var idPrice = 'priceT'+rowid;
        var idQty = "qtyT"+rowid;
        var idTotal = "totalT"+rowid;
        var _token = $('input[name="_token"]').val();
            if(uid != ''){
                $.ajax({
                url:"{{ route('price.getprice')}}",
                method:"POST",
                data:{unit_id:uid, _token:_token},
                success:function(result)
                    {

                        //result 0 => price, 1 => new_name
                        document.getElementById(idPrice).innerHTML = result[0];
                        if(result[1] != ''){
                            document.getElementById(idPname).innerHTML = result[1];
                        }
                        // alert(result);
                        sumAll();
                    }
                });
            }else{
                document.getElementById(idPrice).innerHTML = '0';
                document.getElementById(idTotal).innerHTML = '0';
            }
        }
</script>
@if ( isset($address_id) ? $address_id : '' )
@if ( $address_id != '' )
<script>
    $('select[name=address_id]').val({{$address_id}});
    $('.selectpicker').selectpicker('refresh');
            //var select = $(this).attr("id");
            var value = {{$address_id}};
            //var name = $(this).attr("name");
            //var dependent = $(this).data("dependent");
            var _token = $('input[name="_token"]').val();

            $.ajax({
                url:"{{ route('cart.fetch')}}",
                method:"POST",
                data:{value:value, _token:_token},
                success:function(result)
                {
                    // if(dependent != 'zipcode'){
                    //     $("#"+dependent).html(result);
                    //     //$("#zipcode").val('5555');
                    //     //alert(result);

                    // }else if(dependent == 'zipcode'){
                         $("#testSS").html(result);
                    // }
                    //alert(result);
                }
            })
            //alert(value);
</script>
@endif
@endif

@endsection
