@extends('layouts.backend')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-12">
                <h3 class="m-0 text-dark">เบิกสินค้า <br></h3>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">ข้อมูลผู้เบิกสินค้า</h3>

                    </div>
                    <div class="card-body">
                        <div id="sEmp"></div>
                        <div class="form-inline" id="fEmp">
                            <label for="exampleFormControlInput1">รหัสพนักงาน :</label>
                            {{ Form::text('lot_number', null,['class'=>'form-control ','autocomplete'=>'off'
                                ,'id'=>'emp_id']) }}
                            @if ($errors->has('lot_number'))
                            <div class="invalid-feedback">{{ $errors->first('lot_number') }}</div>
                            @endif
                            <button id="BtnE" type="button" class="btn btn-primary ml-2"
                                onclick="refreshList('e')">OK</button>
                        </div>
                    </div>

                </div>
                <!-- /.card -->
            </div>
            <div class="col-md-12">
                <!-- Default box -->

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">รายการสินค้าที่เบิก</h3>
                    </div>
                    <div class="card-body">
                        <div class="form-inline" id="fProduct" hidden>
                            <label for="exampleFormControlInput1">รหัสสินค้า :</label>
                            {{ Form::text('product_id', null,['class'=>'form-control ','autocomplete'=>'off'
                                ,'id'=>'product_id']) }}
                            @if ($errors->has('product_id'))
                            <div class="invalid-feedback">{{ $errors->first('product_id') }}</div>
                            @endif
                            <button id="BtnP" type="button" class="btn btn-primary ml-2"
                                onclick="refreshList('p')">OK</button>
                            <button id="myBtn" type="button" class="btn btn-secondary ml-2" rel="tooltip"
                                title="รายการสินค้า" onclick="" data-toggle="modal" data-target="#myStock"><i
                                    class="fa fa-bars" aria-hidden="true"></i></button>
                        </div>
                        <table class="table text-nowrap">
                            <thead>
                                <tr>
                                    <th scope="col">ชื่อสินค้า</th>
                                    <th scope="col">Lot</th>
                                    <th scope="col">Exp</th>
                                    <th scope="col">จำนวน</th>
                                    <th scope="col">หน่วย</th>
                                    <th scope="col">คงเหลือ</th>
                                    <th scope="col"></th>

                                </tr>
                            </thead>
                            <tbody id="ListW">

                            </tbody>
                        </table>
                    </div>

                </div>
                <!-- /.card -->
                <div id="fCF" hidden>

                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">ที่อยู่ผู้รับสินค้า</h3>

                        </div>
                        <div class="card-body">
                            <div class="form-group col-lg-6">
                                <label></label>
                                @php
                                $groupUser = [1,14,25,26,27,28,29];
                                @endphp
                                {{ Form::select('address_id', App\Address::whereIn('user_id', $groupUser)->pluck('name',
                                            'id'), null, ['class' => 'selectpicker form-control', 'placeholder' => 'กรุณาเลือกที่อยู่...'
                                            , 'required','data-live-search="true"','id'=>'SelAddress']) }}
                                @if ($errors->has('address_id'))
                                <div class="invalid-feedback">{{ $errors->first('address_id') }}</div>
                                @endif
                            </div>
                        </div>

                    </div>
                    <!-- /.card -->

                    <button type="button" class="btn btn-success" onclick="chkAddress()">ยืนยัน</button>
                </div>
            </div>

        </div>
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->

<!-- Modal -->
<div class="modal fade" id="myStock" role="dialog">
    <div class="modal-dialog  modal-lg modal-dialog-centered">

        <!-- Modal content-->
        <div class="modal-content" id="myModalPic2">
            <div class="card">

                <div class="card-header">
                    <form class="form-inline ml-3 mr-3 mt-2 mb-2">
                        <input class="form-control form-control-sm mr-3 w-75" type="text" placeholder="Search"
                            aria-label="Search" onkeyup="StockFetch(this.id)" id="txtSearch">
                        <i class="fa fa-search" aria-hidden="true"></i>
                    </form>
                </div>
                <div class="card-body row" id="product_fetch">
                </div>
            </div>
        </div>

    </div>
</div>
{{-- END Model --}}

@endsection


@section('footerscript')

<script>
    function StockFetch(id){

            var _token = $('input[name="_token"]').val();
            var value = document.getElementById('txtSearch').value;

                    $.ajax({
                        url:"{{ route('stock.fetch')}}",
                        method:"POST",
                        data:{key:value, _token:_token},
                        success:function(result)
                        {
                                 $("#product_fetch").html(result);
                        }
                    })
        }
        function Add2List(code){
            document.getElementById('product_id').value = code;
            refreshList('p');
        }
</script>

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

<script>
    function chkAddress(){
        var sAddress = document.getElementById('SelAddress');
        if(sAddress.value==''){
            alert('กรุณาเลือกที่อยู่ผู้รับ')
        }else{
            refreshList('p','1');
        }
    }
</script>

<script>
    var input = document.getElementById("emp_id");
        input.addEventListener("keyup", function(event) {
          if (event.keyCode === 13) {
           event.preventDefault();
           document.getElementById("BtnE").click();
          }
        });
    var input = document.getElementById("product_id");
        input.addEventListener("keyup", function(event) {
          if (event.keyCode === 13) {
           event.preventDefault();
           document.getElementById("BtnP").click();
          }
        });
</script>

<script>
    function refreshList(Fn,log_id){

        var ListW = document.getElementById('ListW');

        var _token = $('input[name="_token"]').val();
        var emp_id = document.getElementById('emp_id');
        var product_id = document.getElementById('product_id');
        var sAddress = document.getElementById('SelAddress');

        var sEmp = document.getElementById('sEmp');
        var fEmp = document.getElementById('fEmp');
        var fProduct = document.getElementById('fProduct');
        var fCF = document.getElementById('fCF');

        if(log_id==''){
            log_id = 0;
        }

        // if(emp_id.value =! ''){
        // }

        $.ajax({
                url:"{{ route('stock.withdraw_fetch')}}",
                method:"POST",
                data:{emp_id:emp_id.value, product_id:product_id.value,Fn:Fn,log_id:log_id,address_id:sAddress.value,_token:_token},
                success:function(result)
                {
                    // var Adata = result.split("||");
                    // var emp = Adata[0];
                    // var rec = Adata[1];
                    if(Fn == 'e'){
                        if(result == 'No_Emp'){
                            alert('ไม่พบรหัสพนักงาน');
                            emp_id.value = '';
                        }else{
                            // alert(result);
                            sEmp.innerHTML = result;
                            fEmp.hidden = true;
                            fProduct.hidden = false;
                            fCF.hidden = false;
                            // emp_id.value = '';
                            refreshList('p');
                        }
                    }else if(Fn == 0){
                        if(result == 'Cant_Del'){
                            alert('Error ไม่สามารถลบได้');
                        }else{

                            refreshList('p');
                        }
                    }
                    else if(Fn == 'p'){
                        if(result=='No_Product_id'){
                            alert('ไม่พบสินค้า');
                            product_id.value = '';
                            product_id.focus();
                        }else if(result=='No_Product'){
                            alert('สินค้าขาดสต็อก');
                            product_id.value = '';
                            product_id.focus();
                        }else if(result=='No_ProductW'){
                            alert('สินค้าไม่เพียงพอ เนื่องจากมีการอัพเดทสต๊อก');
                            product_id.value = '';
                            product_id.focus();
                            refreshList('p');
                        }else if(result=='refresh'){
                            product_id.value = '';
                            product_id.focus();
                            refreshList('p');
                        }else if(result=='over_stock'){
                            alert('สต็อกสินค้าไม่เพียงพอ');
                            product_id.value = '';
                            product_id.focus();
                            refreshList('p');
                        }else if(result=='W_Success'){

                            swal("เบิกสินค้าสำเร็จ","ผลการทำงาน","success");
                            sAddress.selectedIndex = 'null';
                            sAddress.value = 0;
                            product_id.focus();
                            refreshList('p');
                        }
                        else{
                            ListW.innerHTML = result;
                        }
                    }
                    product_id.value = '';
                    product_id.focus();

                }
            })
    }
</script>
<script>
    function ChkMax(max,num,id){
        if(max-num < 0){
            alert('สต็อกไม่เพียงพอ');
            document.getElementById(id).value = max;
        }else{
            var log_ids = id.substring(3);
            // alert(log_ids);
            document.getElementById('hLog'+log_ids).style = '';
            var _token = $('input[name="_token"]').val();
            $.ajax({
                    url:"{{ route('stock.withdraw_fetch2')}}",
                    method:"POST",
                    data:{total:num,log_ids:log_ids,_token:_token},
                    success:function(result)
                    {
                        //
                    }
                })
        }
}
</script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","Error");
</script>
@endif

<!-- Latest compiled and minified CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/css/bootstrap-select.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/js/bootstrap-select.min.js"></script>

<script>
    $('select').selectpicker();
</script>
@endsection