@extends('layouts.backend')

@section('content')

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                        <h3>Lot Number
                        <span class="ml-2">
                            <a href="{{ route('stock.lot_create',['product_id'=>$product_id]) }}" class="btn btn-success mb-2">
                                <i class="fa fa-plus-circle text-white"> เพิ่ม</i>
                            </a>
                        </span>
                    </h3>
                </div>
                <div class="card-body" style="overflow-x: auto;">
                    <table class="table text-nowrap">
                        <thead>
                            <tr>
                                <th scope="col">Lot/Serial Number</th>
                                <th scope="col">exp</th>
                                <th scope="col">หมายเหตุ</th>
                                <th scope="col"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($lot_number as $indexKey => $Lot)

                            <tr>
                                <td>
                                    {{ $Lot->lot }}
                                </td>
                                <td>
                                    {{ $Lot->exp }}
                                </td>
                                <td>
                                    {{ $Lot->remark }}
                                </td>
                                <td>
                                    <button class="btn btn-primary btn-sm" onclick="edit({{$Lot->id}})">
                                        <i class="fa fa-pencil-square-o text-white"> แก้ไข</i>
                                    </button>
                                    {{-- <button class="btn btn-danger btn-sm" onclick="del($Lot->id)">
                                        <i class="fa fa-trash-o text-white"> ลบ</i>
                                    </button> --}}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <br>
                    {{$lot_number->links()}}
                </div>
            </div>

            <span class="ml-2">
                <a href="{{ route('stock.addStock',['product_id'=>$product_id]) }}" class="btn btn-primary mb-2">
                    <i class="fa fa-chevron-circle-left text-white"> Back กลับ</i>
                </a>
            </span>

        </div>


    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->
@endsection

@section('footerscript')

<script>
    function edit(id){

        var url = '{{ route('stock.lot_edit',['lot_id'=>':id']) }}';
        url = url.replace(':id',id);
        // alert(url);
        // alert(id);

        window.location.replace(url);
    }
</script>

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

@endsection
