@extends('layouts.backend')
@section('content')

<div class="card mx-1 my-2">
    <div class="card-header">
    <h3 class="card-title">แก้ไขหน่วยสินค้า</h3>
    </div>

    <div class="card-body">

            @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            {!! Form::open(['novalidate','route' => 'stock.unit_update', 'method' => 'post', 'files' => true,'class'=>
            ($errors->any()) ? 'was-validated' : 'needs-validation']) !!}
            {{-- <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}" method="post"
            enctype="multipart/form-data"
            action="{{ route('product.store') }}">
            @csrf --}}

            <div class="form-group">
                <label for="exampleFormControlInput1">หน่วย (Unit)</label> {{ Form::text('name', $unit_number->name,['class'=>'form-control ',
                        'autocomplete'=>'off','required']) }}
                @if ($errors->has('name'))
                <div class="invalid-feedback">{{ $errors->first('name') }}</div>
                @endif
            </div>
            @php
            $unit = App\Unit::where('product_id', $product_id)->get();

            @endphp
            <div class="form-group">
                <label>จำนวนต่อหน่วย</label> {{ Form::number('per_parent', $unit_number->per_parent,['class'=>'form-control ', 'placeholder' => 'จำนวน...'
                            ,'autocomplete' => 'off','required']) }}
                @if ($errors->has('per_parent'))
                <div class="invalid-feedback">{{ $errors->first('per_parent') }}</div>
                @endif
            </div>

            @php
            $unit_p = App\Unit::where('product_id', $product_id)->where('id', '!=' , $unit_number->id)->get();
            @endphp

            @if($unit_number->parent_id != 0)
            <div class="form-group">
                <label>หน่วย</label>
                {{ Form::select('parent_id', $unit_p->pluck('name','id'),
                $unit_number->parent_id, ['class' => 'form-control dynamic', 'placeholder' => 'กรุณาเลือกหน่วย...',
                'required','id'=>'SelAddress','onchange'=>'testS(this.value)']) }}
                @if ($errors->has('parent_id'))
                <div class="invalid-feedback">{{ $errors->first('parent_id') }}</div>
                @endif
            </div>

            @else
            <div class="form-group">
                <label>หน่วย</label>
                {{ Form::select('parent_id', array('0' => '-'), '0'
                , ['class' => 'form-control dynamic',
                'required','id'=>'SelAddress','onchange'=>'testS(this.value)']) }}
                @if ($errors->has('parent_id'))
                <div class="invalid-feedback">{{ $errors->first('parent_id') }}</div>
                @endif
            </div>

            @endif

            <input type="text" name="unit_id" value="{{ $unit_number->id }}" hidden>
            <input type="text" name="product_id" value="{{ $product_id }}" hidden>

            <button type="submit" class="btn btn-primary mt-3">แก้ไข</button>

            <span class="ml-2">
                <a href="{{ route('stock.addStock',['product_id'=>$product_id]) }}" class="btn btn-secondary mt-3">
                    <i class="fa fa-chevron-circle-left text-white"> Back กลับ</i>
                </a>
            </span>

            </form>

        </div>
    <!-- /.card-body -->
</div>
@endsection
@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","error");
</script>
@endif

@endsection
