@extends('layouts.backend')
@section('content')

<div class="card mx-1 my-2">
    <div class="card-header">
    <h3 class="card-title">เพิ่ม Serial/Lot Number</h3>
    </div>

    <div class="card-body">

        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        {!! Form::open(['novalidate','route' => 'stock.lot_store', 'method' => 'post', 'files' => true,'class'=>
        ($errors->any()) ? 'was-validated' : 'needs-validation']) !!}
        {{-- <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}" method="post"
        enctype="multipart/form-data"
        action="{{ route('product.store') }}">
        @csrf --}}

        <div class="form-group">
            <label for="exampleFormControlInput1">Lot Number</label> {{ Form::text('lot_number', null,['class'=>'form-control ',
                    'autocomplete'=>'off','required']) }}
            @if ($errors->has('lot_number'))
            <div class="invalid-feedback">{{ $errors->first('lot_number') }}</div>
            @endif
        </div>

        <div class="form-group">
            <label for="exampleFormControlInput1">Exp :</label>
            {{ Form::date('exp', null,['class'=>'form-control DaddrDefault',
                                            'placeholder' => 'วันที่...','required', 'id' => 'exp'
                                            ,'onchange' => 'highlight_box_address(this.id)','autocomplete'=>'off']) }}
            @if ($errors->has('exp'))
            <div class="invalid-feedback">{{ $errors->first('exp') }}</div>
            @endif
        </div>

        <div class="form-group">
            <label for="exampleFormControlInput1">หมายเหตุ</label> {{ Form::text('remark', null,['class'=>'form-control ',
                    'autocomplete'=>'off','placeholder'=>'-']) }}
            @if ($errors->has('remark'))
            <div class="invalid-feedback">{{ $errors->first('remark') }}</div>
            @endif
        </div>

        <input type="text" name="product_id" value="{{ $product_id }}" hidden>

        <button type="submit" class="btn btn-primary mt-3">เพิ่ม</button>

        <span class="ml-2">
            <a href="{{ route('stock.lot_index',['product_id'=>$product_id]) }}" class="btn btn-secondary mt-3">
                <i class="fa fa-chevron-circle-left text-white"> Back กลับ</i>
            </a>
        </span>

        </form>

    </div>
    <!-- /.card-body -->
</div>
@endsection
