@extends('layouts.backend')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">สต๊อกสินค้า</h1>
            </div>
            <!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">Stock</li>
                </ol>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h4>เบิกสินค้า</h4>

                        <p>(Withdraw)</p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-pie-graph"></i>
                    </div>
                    <a href="{{route('stock.withdraw_index')}}" class="small-box-footer">เลือก <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-success">
                    <div class="inner">
                        <h4>นำเข้าสินค้า</h4>

                        <p>(Import)</p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                    </div>
                    <a href="{{route('stock.preImport',['xx'=>'category'])}}" class="small-box-footer">เลือก <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-info">
                    <div class="inner">
                        <h4>ประวัติ</h4>

                        <p>(history)</p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                    </div>
                    <a href="{{route('stock.history_index',['product_id'=>'0'])}}" class="small-box-footer">เลือก <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
        </div>
        <!-- /.row -->
        <!-- Main row -->
        <div class="row">
            <div class="col-md-12">
                <!-- Default box -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">เลือกประเภทสินค้า</h3>

                    </div>
                    <div class="card-body">
                        <div class="row" >

                            @foreach ($category as $c)
                            <div class="col-lg-4 col-6" >
                                <!-- small box -->
                                <div class="small-box bg-secondary" onclick="go2stockType('{{ $c->id }}')">
                                    <div class="inner">
                                        <h4>{{ $c->name }}</h4>
                                    </div>
                                </div>
                            </div>
                            @endforeach

                        </div>
                    </div>

                </div>
                <!-- /.card -->
            </div>
        </div>
        <!-- /.row (main row) -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->
@endsection


@section('footerscript')

<script>
function go2stockType(id){
    // alert(id);
    var url = '{{ route('stock.category',['category_id'=>':id']) }}';
        url = url.replace(':id',id);
        // alert(url);

        window.location.replace(url);
}
</script>

@endsection
