@extends('layouts.backend')

@section('content')

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h3>ประวัติการเบิกสินค้า</h3>
                </div>

                <div class="form-group col-lg-6">
                    <label></label>
                    {{ Form::select('product_id', App\Product::all()->pluck('name',
                                'id'), $product_id, ['class' => 'selectpicker form-control', 'placeholder' => 'ค้นหาจากรายชื่อสินค้า...'
                                , 'required','data-live-search="true"','id'=>'SelAddress','onchange'=>'SearchByP(this.value)']) }}
                    @if ($errors->has('product_id'))
                    <div class="invalid-feedback">{{ $errors->first('product_id') }}</div>
                    @endif
                </div>

                <div class="card-body" style="overflow-x: auto;">
                    {{-- <input class="form-control form-control-sm mr-3 w-25" type="text" placeholder="ชื่อสินค้า..."
                            aria-label="Search" onkeyup="SearchName(this.value)"> --}}

                    <table class="table text-nowrap">
                        <thead>
                            <tr>
                                <th scope="col">วันที่</th>
                                <th scope="col">ชื่อสินค้า</th>
                                <th scope="col">Lot</th>
                                <th scope="col">จำนวน</th>
                                <th scope="col">หน่วย</th>
                                <th scope="col">ผู้รับ</th>
                            </tr>
                        </thead>
                        <tbody id="ListLog">
                            @if (count($stock_log)>0)
                            @foreach ($stock_log as $indexKey => $s)
                            @if (isset($s->stock->product->name))
                            <tr>
                                <td>
                                    {{ $s->date }}
                                </td>
                                <td>
                                    {{ $s->stock->product->name }}
                                </td>
                                <td>
                                    {{ $s->stock->lot->lot }}
                                </td>
                                <td>
                                    {{ $s->total }}
                                </td>
                                <td>
                                    {{ $s->stock->unit->name }}
                                </td>
                                <td>
                                    {{ $s->address->name }}
                                </td>
                            </tr>
                            @endif
                            @endforeach
                            @endif
                        </tbody>
                        <tbody id="ListLogS" hidden>
                            <tr>
                            </tr>
                        </tbody>
                    </table>
                    <br>
                    <div id="LinkB">
                        @if (count($stock_log)>0)
                        {{$stock_log->links()}}
                        @endif
                    </div>
                </div>
            </div>

            {{-- <span class="ml-2">
                <a href="{{ route('stock.addStock',['product_id'=>$product_id]) }}" class="btn btn-primary mb-2">
            <i class="fa fa-chevron-circle-left text-white"> Back กลับ</i>
            </a>
            </span> --}}

        </div>


    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->
@endsection

@section('footerscript')

<script>
    function SearchByP(id){
    if(id == ''){
        id = 0;
    }
    // alert(id);
    var url = '{{ route('stock.history_index',['product_id'=>':id']) }}';
        url = url.replace(':id',id);
        // alert(url);

        window.location.replace(url);
}
</script>

<script>
    function SearchName(Pname){
    if(Pname == ''){
        document.getElementById('LinkB').hidden = false;
        document.getElementById('ListLog').hidden = false;
        document.getElementById('ListLogS').hidden = true;
    }else{
        document.getElementById('LinkB').hidden = true;
        document.getElementById('ListLog').hidden = true;
        document.getElementById('ListLogS').hidden = false;

            var _token = $('input[name="_token"]').val();
            $.ajax({
                    url:"{{ route('stock.search_fetch')}}",
                    method:"POST",
                    data:{Pname:Pname,_token:_token},
                    success:function(result)
                    {
                        document.getElementById('ListLogS').innerHTML = result;
                    }
                })
    }
}
</script>

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

<!-- Latest compiled and minified CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/css/bootstrap-select.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/js/bootstrap-select.min.js"></script>

<script>
    $('select').selectpicker();
</script>

@endsection
