@extends('layouts.backend')

@section('content')

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-header">
                    <h4>{{ $product->name }}</h4>
                </div>

                <div class="card-body" style="overflow-x: auto;">
                    <div class="col-md-12">
                        <img class="card-img-top" src="{{asset('../shopping/storage/app/public/images/'.$product->picture)}}"
                            style="max-height:350px;width:auto;" alt="">
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h4>สต๊อกสินค้า</h4>
                </div>

                <div class="card-body" style="overflow-x: auto;">
                    {{-- <input class="form-control form-control-sm mr-3 w-25" type="text" placeholder="ชื่อสินค้า..."
                            aria-label="Search" onkeyup="SearchName(this.value)"> --}}

                    <table class="table text-nowrap">
                        <thead>
                            <tr>
                                <th scope="col">ชื่อสินค้า</th>
                                <th scope="col">Lot</th>
                                <th scope="col">คงเหลือ</th>
                                <th scope="col">หน่วย</th>
                                <th scope="col">Barcode</th>
                            </tr>
                        </thead>
                        <tbody id="ListLog">
                            @if (count($stock)>0)
                            @foreach ($stock as $indexKey => $s)
                            <tr>
                                <td>
                                    {{ $s->product->name }}
                                </td>
                                <td>
                                    {{ $s->lot->lot }}
                                </td>
                                <td>
                                    {{ $s->total }}
                                </td>
                                <td>
                                    {{ $s->unit->name }}
                                </td>
                                <td>
                                        <button type="button" class="btn btn-primary"
                                        onclick="printBarcode('{{ $s->id }}')"><i class="fa fa-print" aria-hidden="true"></i>
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                            @endif
                        </tbody>
                        <tbody id="ListLogS" hidden>
                            <tr>
                            </tr>
                        </tbody>
                    </table>
                    <br>
                    {{-- <div id="LinkB">
                        @if (count($stock_log)>0)
                        {{$stock_log->links()}}
                    @endif
                </div> --}}
            </div>
        </div>

    </div>


</div>
<!-- end row -->
</div>
<!-- /.container-fluid -->
@endsection

@section('footerscript')

<script>
    function printBarcode(id){
    // alert(id);
    var url = '{{ route('stock.stockBarcode',['stock_id'=>':id']) }}';
        url = url.replace(':id',id);
        // alert(url);

        window.open(url);
}
</script>


<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

@endsection
