@extends('layouts.backend')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-12">
                <h3 class="m-0 text-dark">นำเข้าสินค้า <br><span
                        style="color:blue;font-size:80%">{{ $product->name }}</span></h3>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}" method="post"
            enctype="multipart/form-data" action="{{ route('stock.store') }}">
            @csrf
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">หน่วยสินค้า
                                <span class="ml-2">
                                    @if(count($unit)<1) <a
                                        href="{{ route('stock.unit_create',['product_id'=>$product->id]) }}"
                                        class="btn btn-success btn-sm mb-1">
                                        <i class="fa fa-plus-circle text-white"> เพิ่ม</i>
                                        </a>
                                        @else
                                        @endif

                                </span>
                            </h3>

                        </div>
                        <div class="card-body" style="overflow-x: auto;">

                            @if(count($unit)>0)
                            <table class="table text-nowrap">
                                <thead>
                                    <tr>
                                        <th scope="col">หน่วย</th>
                                        <th scope="col">จำนวน</th>
                                        <th scope="col">ต่อ</th>
                                        <th scope="col"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($unit as $indexKey => $u)
                                    @php
                                    if($u->parent_id != 0){
                                    $unit_name = App\Unit::find($u->parent_id)->first();
                                    $Uname = $unit_name->name;
                                    }else {
                                    $Uname = '-';
                                    }
                                    @endphp
                                    <tr>
                                        <td>
                                            {{ $u->name }}
                                        </td>
                                        <td>
                                            {{ $u->per_parent }}
                                        </td>
                                        <td>
                                            {{ $Uname }}
                                        </td>
                                        <td>
                                                <button class="btn btn-primary btn-sm" type="button" onclick="edit({{$u->id}})">
                                                    <i class="fa fa-pencil-square-o text-white"> แก้ไข</i>
                                                </button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            @else
                            ยังไม่มีหน่วยสินค้า
                            @endif
                            <br>
                        </div>

                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">รายการสินค้าคงเหลือ</h3>

                        </div>
                        <div class="card-body" style="overflow-x: auto;">

                            @if(count($unit)>0)
                            <table class="table text-nowrap">
                                <thead>
                                    <tr>
                                        <th scope="col">จำนวน</th>
                                        <th scope="col">หน่วย</th>
                                        <th scope="col"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($stock_total as $s)
                                    <tr>
                                        <td>
                                            {{$s->total_all  }}
                                        </td>
                                        <td>
                                            {{$s->unit->name }}
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            @else
                            ยังไม่มีสต็อกสินค้า
                            @endif
                            <br>
                        </div>

                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-md-12">
                    <!-- Default box -->

                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">นำเข้าสินค้า</h3>

                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    @endif

                                    <div class="form-group" hidden>
                                        <label>รหัสพนักงาน</label> {{ Form::text('emp_id', '1',['class'=>'form-control ', 'placeholder' => 'รหัสพนักงาน...'
                                                    ,'autocomplete' => 'off','required']) }}
                                        @if ($errors->has('emp_id'))
                                        <div class="invalid-feedback">{{ $errors->first('emp_id') }}</div>
                                        @endif
                                    </div>

                                    <div class="form-group">
                                        <label>Lot Number สินค้า</label>
                                        {{ Form::select('lot_id', App\LotNumber::where('product_id', $product->id)->pluck('lot',
                                                    'id'), null, ['class' => 'selectpicker form-control dynamic', 'placeholder' => 'กรุณาเลือก Lot Number...'
                                                    , 'required','data-live-search="true"','id'=>'SelAddress','onchange'=>'testS(this.value)']) }}
                                        @if ($errors->has('lot_id'))
                                        <div class="invalid-feedback">{{ $errors->first('lot_id') }}</div>
                                        @endif
                                        <div class="my-2 text-right"><a
                                                href="{{ route ('stock.lot_index',['product_id'=>$product->id]) }}">แก้ไข/เพิ่ม</a>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="exampleFormControlInput1">วันที่นำเข้า (ค.ศ. ตัวอย่าง
                                            12/12/2019)</label>
                                        {{ Form::date('date', $DateNow,['class'=>'form-control DaddrDefault',
                                                                        'placeholder' => 'วันที่...','required', 'id' => 'date'
                                                                        ,'onchange' => 'highlight_box_address(this.id)','autocomplete'=>'off']) }}
                                        @if ($errors->has('date'))
                                        <div class="invalid-feedback">{{ $errors->first('date') }}</div>
                                        @endif
                                    </div>

                                    <div class="form-group">
                                        <label>จำนวน</label> {{ Form::number('total', null,['class'=>'form-control ', 'placeholder' => 'จำนวน...'
                                                    ,'autocomplete' => 'off','required']) }}
                                        @if ($errors->has('total'))
                                        <div class="invalid-feedback">{{ $errors->first('total') }}</div>
                                        @endif
                                    </div>

                                    <div class="form-group">
                                        <label>หน่วย</label>
                                        {{ Form::select('unit_id', App\Unit::where('product_id', $product->id)->pluck('name',
                                                'id'), null, ['class' => 'form-control dynamic', 'placeholder' => 'กรุณาเลือกหน่วย...'
                                                , 'required','id'=>'SelAddress','onchange'=>'testS(this.value)']) }}
                                        @if ($errors->has('unit_id'))
                                        <div class="invalid-feedback">{{ $errors->first('unit_id') }}</div>
                                        @endif
                                    </div>

                                    <div class="form-group">
                                        <label for="exampleFormControlInput1">หมายเหตุ</label> {{ Form::text('remark', null,['class'=>'form-control ',
                                                'autocomplete'=>'off','placeholder'=>'-']) }}
                                        @if ($errors->has('remark'))
                                        <div class="invalid-feedback">{{ $errors->first('remark') }}</div>
                                        @endif
                                    </div>
                                    <!-- card.// class="text-right" -->

                                    <input type="text" name="product_id" value="{{ $product->id }}" hidden>

                                    <div>
                                        <button type="submit" class="btn btn-primary mt-3">ยืนยัน</button>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                    <!-- /.card -->
                </div>

            </div>

        </form>
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->
@endsection


@section('footerscript')

<script>
    function edit(id){

        var url = '{{ route('stock.unit_edit',['unit_id'=>':id']) }}';
        url = url.replace(':id',id);
        // alert(url);
        // alert(id);

        window.location.replace(url);
    }
</script>

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

<!-- Latest compiled and minified CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/css/bootstrap-select.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/js/bootstrap-select.min.js"></script>

<script>
    $('select').selectpicker();
</script>
@endsection
