@extends('layouts.backend')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-12">
                <h3 class="m-0 text-dark">สินค้า {{ $category->name }}</h3>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Main row -->
        <div class="row">
            @foreach ($product as $p)

            <div class="col-md-4">
                <!-- Default box -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">{{ $p->name }}</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 text-center">
                                <img class="card-img-top"
                                    src="{{asset('../shopping/storage/app/public/images/'.$p->picture)}}" alt="">
                            </div>
                            <div class="col-md-6">
                                <table class="table text-nowrap">
                                    <thead>
                                        <tr>
                                            <th>คงเหลือ</th>
                                            <th>หน่วย</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @php
                                        $stock = App\Stock::with('unit')
                                        ->select('unit_id', DB::raw('SUM(total) as total_all'))
                                        ->groupBy('unit_id')
                                        ->where('product_id', $p->id)->get();
                                        @endphp

                                        @foreach ($stock as $s)
                                        <tr>
                                            <td>
                                                {{$s->total_all  }}
                                            </td>
                                            <td>
                                                {{$s->unit->name }}
                                            </td>

                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <button type="button" class="btn btn-success btn-sm mt-3"
                                    onclick="go2add('{{ $p->id }}')">นำเข้าสินค้า</button>

                                <button type="button" class="btn btn-primary btn-sm mt-3"
                                    onclick="go2detail('{{ $p->id }}')">รายละเอียด</button>
                            </div>
                        </div>
                        {{-- this --}}
                    </div>

                </div>
                <!-- /.card -->
            </div>
            @endforeach

        </div>
        <br>
        {{$product->links()}}
        <!-- /.row (main row) -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->
@endsection


@section('footerscript')

<script>
    function go2add(id){
    // alert(id);
    var url = '{{ route('stock.addStock',['product_id'=>':id']) }}';
        url = url.replace(':id',id);
        // alert(url);

        window.location.replace(url);
    }
</script>

<script>
    function go2detail(id){
        // alert(id);
        var url = '{{ route('stock.stockDetail',['product_id'=>':id']) }}';
            url = url.replace(':id',id);
            // alert(url);

            window.location.replace(url);
        }
</script>

@endsection