@extends('layouts.backend')

@section('content')

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Dashboard</h1>
            </div>
            <!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">เพิ่มสินค้าสินค้า</li>
                </ol>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>เพิ่มสินค้า</h3>
                    </div>
                    <div class="card-body">

                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif

                        <form method="POST" action="{{route('product.store')}}" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label for="name">ชื่อสินค้า</label>
                                <input name="name" type="text" class="form-control" id="name"
                                    aria-describedby="nameHelp" placeholder="Enter name">
                            </div>

                            <div class="form-group">
                                <label for="price">ราคา</label>
                                <input name="price" type="text" class="form-control" id="price"
                                    aria-describedby="priceHelp" placeholder="Enter price">
                            </div>

                            <div class="form-group">
                                <label for="exampleFormControlSelect1">ประเภทสินค้า</label>
                                {{Form::select('category_id', $category->pluck('name','id'), null, ['placeholder' => 'เลือกประเภทสินค้า...','class'=>'form-control'])}}
                            </div>

                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="picture" name="picture">
                                <label class="custom-file-label" for="validatedCustomFile">เลือกรูปภาพสินค้า...</label>
                            </div>

                            <button type="submit" class="btn btn-primary mt-3">บันทึก</button>

                        </form>

                    </div>
                </div>
            </div>


        </div>
        <!-- end row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->

@endsection
