@extends('layouts.backend')

@section('content')

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Dashboard</h1>
            </div>
            <!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">ประเภทสินค้า</li>
                </ol>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>ราคาสินค้า "{{ $product->name }}"</h3>
                    </div>
                    <div class="card-body">

                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif

                        {!! Form::open(['novalidate','route' => 'price.store', 'method' => 'post','class'=>
                        ($errors->any()) ? 'was-validated' : 'needs-validation']) !!}
                        {{-- <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}"
                        method="post"
                        enctype="multipart/form-data"
                        action="{{ route('product.store') }}">
                        @csrf --}}

                        <h5>เพิ่ม ราคาสินค้า</h5>
                        <div class="form-inline">

                            <div class="form-inline mt-3 mr-3" hidden>
                                <label for="exampleFormControlInput1">id : </label> {{ Form::text('product_id', $product->id,['class'=>'form-control ',
                                                    'required']) }}
                                @if ($errors->has('product_id'))
                                <div class="invalid-feedback">{{ $errors->first('product_id') }}</div>
                                @endif

                            </div>

                            <div class="form-inline mt-3 mr-3">
                                <label for="exampleFormControlInput1">หน่วย : </label> {{ Form::text('unit', null,['class'=>'form-control ',
                                            'required']) }}
                                @if ($errors->has('unit'))
                                <div class="invalid-feedback">{{ $errors->first('unit') }}</div>
                                @endif

                            </div>

                            <div class="form-inline mt-3 mr-3">
                                <label for="exampleFormControlInput1">ราคาต่อหน่วย :</label> {{ Form::text('price', null,['class'=>'form-control ',
                                        'required']) }}
                                @if ($errors->has('price'))
                                <div class="invalid-feedback">{{ $errors->first('price') }}</div>
                                @endif

                            </div>

                            <button type="submit" class="btn btn-success mt-3">เพิ่ม</button>

                        </div>

                        </form>


                    </div>
                    <div class="card-body">

                        {{-- <a href="{{route ('price.createP',['product_id'=>$product->id])}}" class="btn btn-primary
                        btn-lg">เพิ่มราคาสินค้า</a> --}}

                        @if (count($price) > 0)

                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">หน่วย</th>
                                    <th scope="col">ราคา/หน่วย</th>
                                    <th scope="col">เครื่องมือ</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($price as $p)
                                <tr>
                                    <td>{{$p->unit}}</td>
                                    <td>{{number_format($p->price,2)}}</td>
                                    <td>
                                        <a href="{{ route('price.edit',['id'=>$p->id]) }}"
                                            class="btn btn-info btn-sm d-inline mr-2">
                                            <li class="fa fa-pencil text-white">

                                            </li>
                                        </a>
                                        <form method="POST" action="{{ route('price.destroy',['id'=>$p->id]) }}"
                                            class="d-inline"
                                            onsubmit="return confirm('คุณต้องการลบข้อมูลใช่ หรือไม่?')">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-danger btn-sm">
                                                <li class="fa fa-trash text-white"></li>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                        <br>
                        {{$price->links()}}


                        @else

                        <p class="mt-4">--- ยังไม่มีราคาสินค้า ---</p>

                        @endif
                    </div>
                </div>
            </div>


        </div>
        <!-- end row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->

@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif
@endsection
