@extends('layouts.backend')
@section('content')

<div class="card mx-1 my-2">
    <div class="card-header">
        <h3 class="card-title">แก้ไขราคาสินค้า -> {{$product->name}} </h3>
    </div>

    <div class="card-body">

        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        {!! Form::model($price, ['novalidate','route' => ['price.update',$price->id], 'method' => 'put', 'files' =>
        true,'class'=> ($errors->any()) ? 'was-validated' : 'needs-validation']) !!}
        {{-- <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}" method="post"
        enctype="multipart/form-data"
        action="{{ route('product.store') }}">
        @csrf --}}

        <div class="form-group">

            <div class="form-group">
                <label for="exampleFormControlInput1">หน่วย : </label> {{ Form::text('unit', null,['class'=>'form-control ',
                                    'required']) }}
                @if ($errors->has('unit'))
                <div class="invalid-feedback">{{ $errors->first('unit') }}</div>
                @endif

            </div>

            <div class="form-group">
                <label for="exampleFormControlInput1">ราคาต่อหน่วย :</label> {{ Form::text('price', null,['class'=>'form-control ',
                                'required']) }}
                @if ($errors->has('price'))
                <div class="invalid-feedback">{{ $errors->first('price') }}</div>
                @endif

            </div>

            <button type="submit" class="btn btn-primary mt-3">บันทึก</button>

        </div>

        </form>


    </div>
    <!-- /.card-body -->
</div>
@endsection


@section('footerscript')

<!-- Latest compiled and minified CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/css/bootstrap-select.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.2/js/bootstrap-select.min.js"></script>

<script>
    $('select').selectpicker();
</script>
@endsection
