@extends('layouts.frontend')

@section('content')

<div class="container-fluid">
    <div class="row my-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h3>เพิ่มที่อยู่</h3>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    {!! Form::open(['novalidate','route' => 'address.store', 'method' => 'post','class'=>
                    ($errors->any()) ? 'was-validated' : 'needs-validation']) !!}
                    {{-- <form novalidate class="{{ ($errors->any()) ? 'was-validated' : 'needs-validation' }}"
                    method="post"
                    enctype="multipart/form-data"
                    action="{{ route('product.store') }}">
                    @csrf --}}

                    <div class="form-group">
                        <label for="exampleFormControlInput1">ชื่อ</label> {{ Form::text('name', null,['class'=>'form-control',
                                    'required']) }}
                        @if ($errors->has('name'))
                        <div class="invalid-feedback">{{ $errors->first('name') }}</div>
                        @endif
                    </div>

                    <div class="form-group">
                        <label for="exampleFormControlInput1">ที่อยู่</label> {{ Form::text('address', null,['class'=>'form-control ',
                                        'placeholder' => 'เลขที่_  หมู่ที่_','required']) }}
                        @if ($errors->has('address'))
                        <div class="invalid-feedback">{{ $errors->first('address') }}</div>
                        @endif
                    </div>

                    <div class="form-inline">
                        <div class="form-group mr-2 mb-4">
                            <div class="form-group">
                                <label for="exampleFormControlSelect1">จังหวัด : </label>
                                {{ Form::select('province', $province->pluck('name_th','name_th'), null,
                            ['class' => 'form-control dynamic', 'placeholder' => 'เลือกจังหวัด...', 'required'
                                        , 'data-dependent' => 'districts' , 'id' => 'provinces']) }}
                                @if ($errors->has('provinces'))
                                <div class="invalid-feedback">{{ $errors->first('provinces') }}</div>
                                @endif
                            </div>
                        </div>

                        <div class="form-group mr-2 mb-4">
                            <div class="form-group">
                                <label for="exampleFormControlSelect2">อำเภอ/เขต : </label>
                                {{ Form::select('district',array(), null
                                , ['class' => 'form-control dynamic', 'placeholder' => 'เลือกอำเภอ/เขต...', 'required'
                                , 'data-dependent' => 'sub_districts' , 'id' => 'districts']
                                ) }}
                                @if ($errors->has('districts'))
                                <div class="invalid-feedback">{{ $errors->first('districts') }}</div>
                                @endif
                            </div>
                        </div>

                        <div class="form-group mr-2 mb-4">
                            <div class="form-group">
                                <label for="exampleFormControlSelect2">ตำบล/แขวง : </label>
                                {{ Form::select('sub_district',array(), null
                                , ['class' => 'form-control dynamic', 'placeholder' => 'เลือกตำบล/แขวง...', 'required'
                                , 'data-dependent' => 'zipcode' , 'id' => 'sub_districts']
                                ) }}
                                @if ($errors->has('sub_districts'))
                                <div class="invalid-feedback">{{ $errors->first('sub_districts') }}</div>
                                @endif
                            </div>
                        </div>

                    </div>
                    {{-- {{ csrf_field() }} --}}

                    <div class="form-inline">

                        <div class="form-group mr-2">
                            <label for="exampleFormControlInput1">รหัสไปรษณีย์ :</label> {{ Form::text('zipcode', null,['class'=>'form-control ',
                                    'required', 'id' => 'zipcode']) }}
                            @if ($errors->has('zipcode'))
                            <div class="invalid-feedback">{{ $errors->first('zipcode') }}</div>
                            @endif
                        </div>

                        <div class="form-group">
                            <label for="exampleFormControlInput1">โทรศัพท์ :</label> {{ Form::text('tel', null,['class'=>'form-control ',
                                    'required']) }}
                            @if ($errors->has('tel'))
                            <div class="invalid-feedback">{{ $errors->first('tel') }}</div>
                            @endif
                        </div>

                    </div>

                    <button type="submit" class="btn btn-primary mt-5">บันทึก</button>

                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
</div>
<!-- /.container-fluid -->
@endsection

@section('footerscript')

<script src="{{ asset('js/sweetalert.min.js') }}"></script>

@if(session('feedback'))
<script>
    swal("{{session('feedback')}}","ผลการทำงาน","success");
</script>
@endif

<script>
    $(document).ready(function(){
    $('.dynamic').change(function(){
        if($(this).val() != '')
        {
            var select = $(this).attr("id");
            var value = $(this).val();
            //var name = $(this).attr("name");
            var dependent = $(this).data("dependent");
            var _token = $('input[name="_token"]').val();

            $.ajax({
                url:"{{ route('address.fetch')}}",
                method:"POST",
                data:{select:select, value:value, _token:_token
                , dependent:dependent},
                success:function(result)
                {
                    if(dependent != 'zipcode'){
                        $("#"+dependent).html(result);
                        //$("#zipcode").val('5555');
                        //alert(result);

                    }else if(dependent == 'zipcode'){
                        $("#"+dependent).val(result);
                    }
                    //alert(result);
                }
            })
            //alert(value);
        }
    });
});
</script>

@endsection
