<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->increments('id');
            //$table->string('invoice_num',12)->default('-');
            //$table->string('date',12)->default('-');
            $table->decimal('total', 12, 2);
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->integer('myorder_id')->unsigned();
            $table->foreign('myorder_id')->references('id')->on('myorders');
            $table->integer('address_id')->unsigned();
            $table->foreign('address_id')->references('id')->on('addresses');
            $table->timestamps();
            // $table->increments('id');
            // $table->integer('invoice_id')->unsigned();
            // $table->foreign('invoice_id')->references('id')->on('invoices')->onCaseCade('delete')->unique();
            // $table->string('code',12)->unique();
            // $table->string('date',15);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
