<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMyorderHasNumbersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('myorder_has_numbers', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('myorder_id')->unsigned();
            $table->foreign('myorder_id')->references('id')->on('myorders')->onCaseCade('delete')->unique();
            $table->string('code',12)->unique();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('myorder_has_numbers');
    }
}
