<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('myorder_id')->unsigned();
            $table->foreign('myorder_id')->references('id')->on('myorders')->onDelete('cascade');
            $table->integer('product_id')->unsigned();
            $table->foreign('product_id')->references('id')->on('products');
            $table->string('product_name',250);
            $table->integer('unit_id')->unsigned();
            $table->foreign('unit_id')->references('id')->on('prices');
            $table->string('unit_name',50);
            $table->decimal('price_now', 12, 2);
            $table->integer('qty')->unsigned();
            $table->integer('invoice_id')->unsigned();
            $table->decimal('total', 12, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
