<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductnamesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('productnames', function (Blueprint $table) {
            $table->integer('address_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->string('name',250);
            $table->foreign('address_id')->references('id')->on('addresses')->onCaseCade('delete');
            $table->foreign('product_id')->references('id')->on('products');
            $table->primary(['address_id','product_id']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('productnames');
    }
}
