<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasRoles,Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    //one to one
    //user()->profile->address();
    public function profile(){
        return $this->hasOne(Profile::class);
    }

    //many to many
    public function products()
    {
        return $this->belongsToMany(Product::class,'carts','user_id','product_id')->withPivot('qty')->withTimestamps();
    }

    //one to many
    public function Addresses()
    {
        //return $this->hasMany(Product::class,cat_id);fk is cat_id
        return $this->hasMany(Address::class); //products table fk is Category_id
    }
}
