<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    //Vatproduct
    public function getVatproductAttribute()
    {
        return $this->price * 0.07;
    }

    //one to many
    public function Addresses()
    {
        //return $this->hasMany(Product::class,cat_id);fk is cat_id
        return $this->hasMany(Cart::class); //products table fk is Category_id
    }

    //many to one
    public function category()
    {
        //cat_id fk of product and c_id pk of category
        //return $this->belongsTo(Category::class,'cat_id','c_id');
        return $this->belongsTo(Category::class);
    }

    //many to many
    public function users()
    {
        return $this->belongsToMany(User::class, 'carts', 'product_id', 'user_id')->withPivot('qty')->withTimestamps();
    }
    public function prices()
    {
        return $this->hasMany(Price::class);
    }

    public static function laratablesCustomAction($product)
    {
        return view('backend.product.includes.action', compact('product'))->render();
    }

    public function laratablesRowData(){
        return [
            'id' => $this->id
        ];
    }
}
