<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Response;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            // 'price' => 'required|numeric',
            'category_id' => 'required',
            'picture'=>'image|mimes:jpeg,jpg,png',
            'picture'=>'max:3240',
        ];
    }

    public function forbiddenResponse(){
        return Response::make('คุณไม่มีสิทธิ์เข้าใช้งานหน้านี้!',403);
    }
    public function messages()
    {
        return [
            'name.required' => 'กรุณากรอกชื่อสินค้า',
            // 'price.required' => 'กรุณากรอกราคา',
            // 'price.numeric' => 'กรุณากรอกราคาเป็นตัวเลข',
            'category_id.required' => 'กรุณาเลือกประเภทสินค้า',
            'picture.image' => 'กรุณาเลือกไฟล์รูปภาพ',
            'picture.mimes' => 'กรุณาเลือกไฟล์รูปภาพที่มีนามสกุล jpeg,jpg,png เท่านั้น',
            'picture.max' => 'กรุณาเลือกไฟล์รูปภาพที่มี ขนาดไม่เกิน 3 MB'
        ];
    }
}
