<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Category;
use App\Product;
use App\Stock;
use DB;

class WelcomeController extends Controller
{
    public function index()
    {

        $category = Category::all();
        $product = Product::latest()->limit(9)->get();

        return view('welcome', [
            'category' => $category,
            'product' => $product
        ]);
    }
    public function show($id)
    {
        //$product = Category::findOrFail($id)->products()->get();

        $categoryAll = Category::all();
        $category = Category::with(['products' => function ($query) {
            $query->orderBy('name');
        }])->where('id', '=', $id)->first();

        return view('show', [
            'categoryAll' => $categoryAll,
            'cat_id' => $id,
            'category' => $category
        ]);
    }

    public function show9(Request $request)
    {
        $output = '';
        if (Product::where('name', 'like', '%' . $request->key . '%')->exists()){
            $product = Product::where('name', 'like', '%' . $request->key . '%')->limit(12)->get();

            for($x=0;$x<count($product);$x++){
                $unitTable = '';
                $stock_total = Stock::with('unit')->select('unit_id', DB::raw('SUM(total) as total_all'))
                    ->groupBy('unit_id')->where('product_id', $product[$x]->id)->get();

                    for($y=0;$y<count($stock_total);$y++){
                        if ($stock_total[$y]->total_all <= 0) {
                            $colorN = 'red';
                        } else if ($stock_total[$y]->total_all < 10) {
                            $colorN = 'orangered';
                        } else if ($stock_total[$y]->total_all >= 10) {
                            $colorN = 'blue';
                        }
                        $unitTable .= '<span style="font-size:150%;color:'.$colorN.'">' . $stock_total[$y]->total_all . '  </span>';
                        $unitTable .= $stock_total[$y]->unit->name;
                        $unitTable .= '<br>';
                    }
                $output .= '<div class="col-lg-4 col-md-6 mb-4">
                <div class="card h-100">
                    <a><img class="card-img-top" src="'.'/../shopping/storage/app/public/images/'.$product[$x]->picture.'"
                            alt=""></a>
                    <div class="card-body">
                        <h4 class="card-title">
                            <a>'.$product[$x]->name.'</a>
                        </h4>

                    </div>
                    <div class="card-footer">
                            <div style="float: left; width: 50%">
                                คงเหลือ<br>'.
                                $unitTable
                                .'<br>
                            </div>
                            <div style="float: right; width: 50%">
                        <button class="btn btn-info float-sm-right" style="float: right;"
                            onclick="add2cart('."'".$product[$x]->id."'".','."'".'S'."'".')">
                            <i class="fa fa-shopping-cart" aria-hidden="true"></i></button>
                    </div>
                </div>
                </div>
            </div>';
            }

        return $output;

        }else {
            return '<h3>ไม่พบสินค้า</h3>';
        }


    }

    public function getCategory() {
        return view('category');
    }

    public function getCategoryAjax() {
        return $category = Category::all();
    }
}
