<?php

namespace App\Http\Controllers;

use App\Stock;
use App\Category;
use App\Product;
use App\LotNumber;
use App\StockLog;
use App\Unit;
use Illuminate\Http\Request;
use DateTime;
use DB;

class StockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $category = Category::orderBy('name')->get();

        return view('backend.stock.index', [
            'category' => $category
        ]);
    }

    public function category($category_id)
    {
        $category = Category::where('id', $category_id)->first();
        $product = Product::where('category_id', $category_id)->orderBy('name')->paginate(12);

        return view('backend.stock.category', [
            'product' => $product,
            'category' => $category
        ]);

        // return $product;
    }

    public function preImport()
    {
        $category = Category::orderBy('name')->get();
        // $product = Product::where('category_id', $category_id)->paginate(12);

        return view('backend.stock.preImport', [
            'category' => $category
        ]);

        // return '5555';
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function addStock($product_id)
    {
        $product = Product::find($product_id);
        $stock = Stock::where('product_id', $product_id)->get();
        $unit = Unit::where('product_id', $product_id)->get();
        $DateNow = new DateTime();
        $stock_total = Stock::with('unit')->select('unit_id', DB::raw('SUM(total) as total_all'))
            ->groupBy('unit_id')->where('product_id', $product_id)->get();

        return view('backend.stock.create', [
            'stock' => $stock,
            'product' => $product,
            'unit' => $unit,
            'DateNow' => $DateNow,
            'stock_total' => $stock_total,
        ]);

        // return $stock;
    }

    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'lot_id' => 'required',
            'date' => 'required',
            'total' => 'required',
            'unit_id' => 'required',
        ], [
            'lot_id.required' => 'กรุณาเลือก Lot number',
            'date.required' => 'กรุณากรอกวันที่นำเข้า',
            'total.required' => 'กรุณากรอกจำนวน',
            'unit_id.required' => 'กรุณาเลือก หน่วย',
        ]);

        if (Stock::where('product_id', $request->product_id)->where('unit_id', $request->unit_id)
            ->where('lot_id', $request->lot_id)->exists()
        ) {
            $MyStock = Stock::where('product_id', $request->product_id)->where('unit_id', $request->unit_id)
                ->where('lot_id', $request->lot_id)->first();

            DB::table('stocks')
                ->where('product_id', $request->product_id)->where('unit_id', $request->unit_id)
                ->where('lot_id', $request->lot_id)
                ->update(['total' => ($MyStock->total) + ($request->total)]);
        } else {
            $Stock = new Stock();
            $Stock->product_id = $request->product_id;
            $Stock->unit_id = $request->unit_id;
            $Stock->lot_id = $request->lot_id;
            $Stock->location_id = 1;
            $Stock->total = $request->total;
            $Stock->status = 'Available';

            $Stock->save();
        }

        $MyStock = Stock::where('product_id', $request->product_id)->where('unit_id', $request->unit_id)
            ->where('lot_id', $request->lot_id)->first();

        $emp = DB::table('_employee')->where('emp_id', $request->emp_id)->first();
        $StockLog = new StockLog();
        $StockLog->date = $request->date;
        $StockLog->emp_id = $emp->id;
        $StockLog->stock_id = $MyStock->id;
        $StockLog->location_id = 1;
        $StockLog->total = $request->total;
        $StockLog->address_id = 1;
        $StockLog->status = 'IN';

        if ($request->remark == '') {
            $StockLog->remark = '-';
        } else {
            $StockLog->remark = $request->remark;
        }

        $StockLog->save();

        return redirect()->route('stock.preImport', ['xx' => 'category'])->with('feedback', 'นำเข้าสินค้าสำเร็จ');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function show(Stock $stock)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function edit(Stock $stock)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Stock $stock)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function destroy(Stock $stock)
    {
        //
    }

    //Lot Number
    public function lot_index($product_id)
    {
        $lot_number = LotNumber::where('product_id', $product_id)->orderBy('id', 'desc')->paginate(10);

        return view('backend.stock.lot.index', [
            'lot_number' => $lot_number,
            'product_id' => $product_id
        ]);
    }
    public function lot_create($product_id)
    {
        $lot_number = LotNumber::where('product_id', $product_id)->get();

        return view('backend.stock.lot.create', [
            'lot_number' => $lot_number,
            'product_id' => $product_id,
        ]);
    }
    public function lot_edit($lot_id)
    {
        $lot_number = LotNumber::where('id', $lot_id)->first();

        return view('backend.stock.lot.edit', [
            'lot_number' => $lot_number,
            'product_id' => $lot_number->product_id
        ]);
        // return $lot_number;
    }
    public function lot_store(Request $request)
    {
        $request->validate([
            'lot_number' => 'required',
            'exp' => 'required',
        ], [
            'lot_number.required' => 'กรุณากรอก Lot Number',
            'exp.required' => 'กรุณากรอกวันที่ Expire'
        ]);

        $lot_number = new LotNumber();
        $lot_number->product_id = $request->product_id;
        $lot_number->lot = $request->lot_number;
        $lot_number->exp = $request->exp;
        if ($request->remark == '') {
            $lot_number->remark = '-';
        } else {
            $lot_number->remark = $request->remark;
        }

        $lot_number->save();

        return redirect()->route('stock.lot_index', ['product_id' => $request->product_id])->with('feedback', 'เพิ่มสำเร็จ');
        // return $request;
    }

    public function lot_update(Request $request)
    {
        $request->validate([
            'lot_number' => 'required',
            'exp' => 'required',
        ], [
            'lot_number.required' => 'กรุณากรอก Lot Number',
            'exp.required' => 'กรุณากรอกวันที่ Expire'
        ]);

        $lot_number = LotNumber::find($request->lot_id);
        $lot_number->lot = $request->lot_number;
        $lot_number->exp = $request->exp;
        $lot_number->remark = $request->remark;

        $lot_number->save();

        return redirect()->route('stock.lot_index', ['product_id' => $request->product_id])->with('feedback', 'แก้ไขสำเร็จ');
        // return $request;
    }
    //Product Unit
    public function unit_create($product_id)
    {
        $my_unit = LotNumber::where('product_id', $product_id)->get();

        return view('backend.stock.unit.create', [
            'my_unit' => $my_unit,
            'product_id' => $product_id,
        ]);
    }
    public function unit_store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'per_parent' => 'required',
            'parent_id' => 'required',
        ], [
            'name.required' => 'กรุณากรอก หน่วย',
            'per_parent.required' => 'กรุณากรอกจำนวนต่อหน่วย',
            'parent_id.required' => 'กรุณาเลือกหน่วย'
        ]);

        if (Unit::where('product_id', $request->product_id)->where('parent_id', $request->parent_id)->exists()) {
            return redirect()->route('stock.unit_create', ['product_id' => $request->product_id])->with('feedback', 'หน่วยซ้ำ');
        }
        $unit = new Unit();
        $unit->product_id = $request->product_id;
        $unit->name = $request->name;
        $unit->per_parent = $request->per_parent;
        $unit->parent_id = $request->parent_id;

        $unit->save();

        return redirect()->route('stock.addStock', ['product_id' => $request->product_id])->with('feedback', 'เพิ่มหน่วยสำเร็จ');
        // return $request;
    }


    public function unit_edit($unit_id)
    {
        $unit_number = Unit::where('id', $unit_id)->first();

        return view('backend.stock.unit.edit', [
            'unit_number' => $unit_number,
            'product_id' => $unit_number->product_id
        ]);
        // return $lot_number;
    }

    public function unit_update(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'per_parent' => 'required',
            'parent_id' => 'required',
        ], [
            'name.required' => 'กรุณากรอก หน่วย',
            'per_parent.required' => 'กรุณากรอกจำนวนต่อหน่วย',
            'parent_id.required' => 'กรุณาเลือกหน่วย'
        ]);

        if (
            Unit::where('product_id', $request->product_id)->where('parent_id', $request->parent_id)->exists()
            && $request->parent_id != 0
        ) {
            return redirect()->route('stock.unit_edit', ['unit_id' => $request->unit_id])->with('feedback', 'หน่วยซ้ำ');
        }
        $unit = Unit::find($request->unit_id);
        $unit->name = $request->name;
        $unit->per_parent = $request->per_parent;
        $unit->parent_id = $request->parent_id;

        $unit->save();

        return redirect()->route('stock.addStock', ['product_id' => $request->product_id])->with('feedback', 'แก้ไขสำเร็จ');
        // return $request;
    }

    public function withdraw_index()
    {
        $category = Category::all();

        return view('backend.stock.withdraw.index', [
            'category' => $category
        ]);
    }
    public function withdraw_fetch(Request $request)
    {
        if ($request->Fn == 'e') {
            if (isset($request->emp_id)) {
                if (DB::table('_employee')->where('emp_id', $request->emp_id)->exists()) {
                    $empName = DB::table('_employee')->where('emp_id', $request->emp_id)->first();
                    return $empName->name;
                } else {
                    return 'No_Emp';
                }
            }
        }
        if ($request->Fn == '0') {
            if (StockLog::where('id', $request->log_id)->where('emp_id', $request->emp_id)->where('status', 'W8')->exists()) {
                StockLog::destroy($request->log_id);
                return 'refresh';
            } else {
                return 'Cant_Del';
            }
        }
        if ($request->Fn == 'p') {
            $chkE = 0;
            $color = '';
            if (!isset($request->product_id)) {
                $stock_log = StockLog::with('stock')->where('emp_id', $request->emp_id)->where('status', 'W8')
                    ->orderBy('id', 'desc')->get();
                $output = '';
                for ($x = 0; $x < count($stock_log); $x++) {
                    if ($stock_log[$x]->total > $stock_log[$x]->stock->total) {
                        $chkE = $chkE + 1;
                        $color = 'background-color:rgba(255,0,0,0.3)';
                    } else {
                        $color = '';
                    }
                    $output .= '<tr id="hLog' . $stock_log[$x]->id . '"  style="' . $color . '"><td>' . ($stock_log[$x]->stock->product->name) . '</td>';
                    $output .= '<td>' . ($stock_log[$x]->stock->lot->lot) . '</td>'.'<td>' . ($stock_log[$x]->stock->lot->exp) . '</td>';
                    $output .= '<td><input id="Log' . $stock_log[$x]->id . '" type="number" value="' . ($stock_log[$x]->total) . '" min="1" max="'
                        . ($stock_log[$x]->stock->total) . '" onchange="ChkMax(this.max,this.value,this.id)"></td>';
                    $output .= '<td>' . ($stock_log[$x]->stock->unit->name) . '</td>';
                    $output .= '<td><span style="color:blue">' . ($stock_log[$x]->stock->total) . '</span></td>';
                    $output .= '<td><button class="btn btn-danger btn-sm"
                                type="button" onclick="refreshList(0,' . $stock_log[$x]->id . ')">
                                <i class="fa fa-trash text-white"> ลบ</i>
                                </button></td></tr>';
                }
                if ($request->log_id == 1) {
                    if ($chkE > 0) {
                        return 'No_ProductW';
                    } else {
                        $listW = StockLog::where('emp_id', $request->emp_id)->where('status', 'W8')->get();
                        for ($x = 0; $x < count($listW); $x++) {
                            $stockW = Stock::where('id', $listW[$x]->stock_id)->first();

                            DB::table('stock_logs')
                                ->where('id', $listW[$x]->id)->where('emp_id', $request->emp_id)
                                ->update(['status' => 'OUT','address_id'=>$request->address_id]);

                            DB::table('stocks')
                                ->where('id', $listW[$x]->stock_id)
                                ->update(['total' => ($stockW->total) - ($listW[$x]->total)]);
                        }
                        return 'W_Success';
                    }
                } else {
                    return $output;
                }
            } else {
                $product = (explode("-", $request->product_id));

                if (count($product) != 3) {
                    return 'No_Product_id';
                } else if (Stock::where('product_id', $this->con10($product[0]))->where('unit_id', $this->con10($product[2]))
                    ->where('lot_id', $this->con10($product[1]))->exists()
                ) {
                    $ThisStock = Stock::where('product_id', $this->con10($product[0]))->where('unit_id', $this->con10($product[2]))
                        ->where('lot_id', $this->con10($product[1]))->first();
                    if ($ThisStock->total == 0) {
                        return 'No_Product';
                    } else {

                        if (StockLog::where('emp_id', $request->emp_id)->where('stock_id', $ThisStock->id)->where('status', 'W8')->exists()) {
                            $logS = StockLog::where('emp_id', $request->emp_id)->where('stock_id', $ThisStock->id)->where('status', 'W8')->first();
                            if ($logS->total > $ThisStock->total - 1) {
                                DB::table('stock_logs')
                                    ->where('emp_id', $request->emp_id)->where('stock_id', $ThisStock->id)->where('status', 'W8')
                                    ->update(['total' => $ThisStock->total]);
                                return 'over_stock';
                            } else {
                                DB::table('stock_logs')
                                    ->where('emp_id', $request->emp_id)->where('stock_id', $ThisStock->id)->where('status', 'W8')
                                    ->update(['total' => ($logS->total) + 1]);
                            }
                        } else {

                            $StockLog = new StockLog();
                            $StockLog->date = date("Y-m-d");
                            $StockLog->emp_id = $request->emp_id;
                            $StockLog->stock_id = $ThisStock->id;
                            $StockLog->location_id = 1;
                            $StockLog->total = 1;
                            $StockLog->status = 'W8';
                            $StockLog->address_id = 1;

                            $StockLog->save();
                        }

                        return 'refresh';
                        // return $ThisStock->id;
                    }
                } else {
                    return 'No_Product_id';
                }
            }
        }
    }

    public function withdraw_fetch2(Request $request)
    {
        DB::table('stock_logs')
            ->where('id', $request->log_ids)
            ->update(['total' => $request->total]);

        return 'OK';
    }

    public function con10($num32)
    {
        return base_convert($num32, 32, 10);
    }

    public function history_index($product_id)
    {
        if ($product_id != 0) {
            $stock_log = StockLog::with(['stock' => function ($query) use ($product_id) {
                $query->where('product_id', $product_id);
            }])->where('status', 'OUT')->orderBy('date', 'desc')->paginate(15);

            if(count($stock_log) == 0){
                $stock_log = [];
            }
            return view('backend.stock.history.index', [
                'stock_log' => $stock_log,
                'product_id' => $product_id
            ]);
            // return $stock_log;
        } else {
            $stock_log = StockLog::with('stock')->where('status', 'OUT')->orderBy('date', 'desc')->paginate(15);

            if(count($stock_log) == 0){
                $stock_log = [];
            }

            return view('backend.stock.history.index', [
                'stock_log' => $stock_log,
                'product_id' => $product_id
            ]);
        }
        // return $stock_log;
    }

    public function search_fetch(Request $request)
    {
        return 'OK';
    }

    public function stockDetail($product_id)
    {
        $stock = Stock::where('product_id', $product_id)->get();
        $product = Product::where('id', $product_id)->first();

        return view('backend.stock.history.detail', [
            'stock' => $stock,
            'product' => $product
        ]);
        // return $product;
    }
    public function stockBarcode($stock_id)
    {
        $stock = Stock::where('id', $stock_id)->first();
        $code = $this->AddZ($this->con32($stock->product_id),3). '-' . $this->AddZ($this->con32($stock->lot_id),3)
            . '-' . $this->AddZ($this->con32($stock->unit_id),4);
        // return $stock;
        return view('backend.stock.history.code', [
            'stock' => $stock,
            'code' => $code
        ]);
    }
    public function con32($num10)
    {
        return base_convert($num10, 10, 32);
    }
    public function AddZ($str,$l)
    {
        $str = strtoupper($str);
        $addZ = $l - strlen($str);
        if($addZ>0){
            if($addZ == 1){
                return '0'.$str;
            }else if($addZ == 2){
                return '00'.$str;
            }else if($addZ == 3){
                return '000'.$str;
            }
        }else{
            return $str;
        }
    }
    public function fetch(Request $request)
    {
        if ($request->key == '') {
            return '';
        }
        $output = '';
        if (Product::where('name', 'like', '%' . $request->key . '%')->exists()) {
            $product = Product::where('name', 'like', '%' . $request->key . '%')->limit(12)->get();


            for ($x = 0; $x < count($product); $x++) {
                // $unitTable = '';
                // $stock_total = Stock::with('unit')->select('unit_id', DB::raw('SUM(total) as total_all'))
                //     ->groupBy('unit_id')->where('product_id', $product[$x]->id)->get();
                $stock_log = Stock::with('unit')->where('product_id', $product[$x]->id)->get();

                $stockT = '';
                // for ($y = 0; $y < count($stock_total); $y++) {
                //     if ($stock_total[$y]->total_all <= 0) {
                //         $colorN = 'red';
                //     } else if ($stock_total[$y]->total_all < 10) {
                //         $colorN = 'orangered';
                //     } else if ($stock_total[$y]->total_all >= 10) {
                //         $colorN = 'blue';
                //     }
                //     $unitTable .= '<span style="font-size:150%;color:' . $colorN . '">' . $stock_total[$y]->total_all . '  </span>';
                //     $unitTable .= $stock_total[$y]->unit->name;
                //     $unitTable .= '<br>';
                // }

                for ($z = 0; $z < count($stock_log); $z++) {

                    if ($stock_log[$z]->total <= 0) {
                        $colorN = 'red';
                        $btnE = 'disabled';
                    } else if ($stock_log[$z]->total < 10) {
                        $colorN = 'orangered';
                        $btnE = '';
                    } else if ($stock_log[$z]->total >= 10) {
                        $colorN = 'blue';
                        $btnE = '';
                    }

                    $code = $this->AddZ($this->con32($stock_log[$z]->product_id), 3) . '-' . $this->AddZ($this->con32($stock_log[$z]->lot_id), 3)
            . '-' . $this->AddZ($this->con32($stock_log[$z]->unit_id), 4);

                    $stockT .= '<tr id="hLog' . $stock_log[$z]->id . '"  style=""><td>' . ($stock_log[$z]->lot->lot) . '</td>';
                    $stockT .= '<td><span style="color:'.$colorN.'">' . ($stock_log[$z]->total) . '</span></td>';
                    $stockT .= '<td>' . ($stock_log[$z]->unit->name) . '</td>';
                    $stockT .= '<td><button class="btn btn-success float-sm-right" style="float: right;"
                    onclick="Add2List(' . "'" . $code . "'" . ')" '.$btnE.' data-dismiss="modal">
                    <i class="fa fa-check-square" aria-hidden="true"></i></button></td></tr>';
                }
                // for ($z = 0; $z < count($stock_log); $z++) {
                //     $stockT .= $z;
                // }

                if ($stockT != '') {
                    $output .= '<div class="col-lg-6 col-md-6 mb-6">
                        <div class="card h-100">
                            <a><img class="card-img-top" src="' . '/../shopping/storage/app/public/images/' . $product[$x]->picture . '"
                                    alt=""></a>
                            <div class="card-body">
                                <h4 class="card-title">
                                    <a>' . $product[$x]->name . '</a>
                                </h4>

                            </div>
                            <div class="card-footer">



                        <table class="table text-nowrap">
                        <thead>
                            <tr>
                                <th scope="col">Lot</th>
                                <th scope="col">คงเหลือ</th>
                                <th scope="col">หน่วย</th>
                                <th scope="col"></th>
                            </tr>
                        </thead>
                        <tbody id="ListStock">'
                    . $stockT .
                    '</tbody>
                    </table>
                        </div>
                        </div>
                    </div>';
                }
            }

            return $output;
        } else {
            return '<h3>ไม่พบสินค้า</h3>';
        }
    }
    public function SelAll($category_id)
    {
        $product = DB::table('products')->where('category_id', $category_id)->get();

        // return view('backend.stock.SelAll', [
        //     'product' => $product
        // ]);
        $A = '';
        for($x=0 ;$x < count($product) ;$x++){
            if($x==0){
                $A = $product[0]->id;
            }else{
                $A .= ','.$product[$x]->id;
            }
        }
        // return count($product);
        $forum_ids = [];
        foreach ($product as $key => $value) {
            $forum_ids[] = $value->id;
        }
        $ids_ordered = implode(',', $forum_ids);
        //$product = Product::latest()->limit(9)->get();
        $Stock = Stock::whereIn('product_id', $forum_ids)->orderByRaw(DB::raw("FIELD(id, $ids_ordered)"))->get();

        $B = '';
        for($x=0 ;$x < count($Stock) ;$x++){
            if($x==0){
                $B = $Stock[0]->id;
            }else{
                $B .= ','.$Stock[$x]->id;
            }
        }

        return 'product = '.$A.'<br>'.'stock = '.$B;
    }
}
