<?php

namespace App\Http\Controllers;

use App\Product;
use App\Category;
use Illuminate\Http\Request;
use App\Http\Requests\ProductRequest;
use Illuminate\Support\Facades\Storage;
use Image;
use Freshbitsweb\Laratables\Laratables;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$product = Product::orderBy('id','desc')->paginate(20);
        $product = Product::with('category')->orderBy('id', 'desc')->paginate(20);;

        return view('backend.product.index', [
            'product' => $product
        ]);
    }

    public function index2()
    {
        return view('backend.product.index2');
    }

    public function getProductAjax()
    {
        return Laratables::recordsOf(Product::class, function ($query) {
            return $query->orderby('id', 'desc');
        });
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $category = Category::all();
        return view('backend.product.create', [
            'category' => $category
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ProductRequest $request)
    {

        // $request->validate([
        //     'name' => 'required',
        //     'price' => 'required|numeric',
        //     'category_id' => 'required'
        // ],[
        //     'name.required' => 'กรุณากรอกชื่อสินค้า',
        //     'price.required' => 'กรุณากรอกราคา',
        //     'price.numeric' => 'กรุณากรอกราคาเป็นตัวเลข',
        //     'category_id.required' => 'กรุณาเลือกประเภทสินค้า'
        // ]);

        $product = new Product();
        $product->name = $request->name;
        // $product->price = $request->price;
        $product->category_id = $request->category_id;

        //check picture and upload
        if ($request->hasFile('picture')) {
            $newFileName = uniqid() . '.' . $request->picture->extension();
            //upload file
            $request->picture->storeAs('images', $newFileName, 'public'); //s3 sstp
            $product->picture = $newFileName;

            //resize
            $path = Storage::disk('public')->path('images/resize/');
            Image::make($request->picture->getRealPath(), $newFileName)->resize(120, null, function ($constraint) {
                $constraint->aspectRatio();
            })->save($path . $newFileName);
        }

        $product->save();

        return redirect()->route('product.index2')->with('feedback', 'บันทึกข้อมูลเรียบร้อย');
        //return $request->price;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit(Product $product)
    {
        return view('backend.product.edit', [
            'product' => $product
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(ProductRequest $request, Product $product)
    {
        $product->name = $request->name;
        // $product->price = $request->price;
        $product->category_id = $request->category_id;

        //delete file and upload new picture
        if ($product->picture != 'nopic.png') {
            Storage::disk('public')->delete('images/' . $product->picture);
            Storage::disk('public')->delete('images/resize/' . $product->picture);
        }

        if ($request->hasFile('picture')) {
            $newFileName = uniqid() . '.' . $request->picture->extension();
            //upload file
            $request->picture->storeAs('images', $newFileName, 'public'); //s3 sstp
            $product->picture = $newFileName;

            //resize asset('../shopping/storage/app/public/images/'.$p->picture)
            $path = Storage::disk('public')->path('images/resize/');
            Image::make($request->picture->getRealPath(), $newFileName)->resize(120, null, function ($constraint) {
                $constraint->aspectRatio();
            })->save($path . $newFileName);
        }

        $product->save();

        return redirect()->route('product.index2')->with('feedback', 'แก้ไขข้อมูลเรียบร้อย');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $product)
    {
        //delete file
        if ($product->picture != 'nopic.png') {
            Storage::disk('public')->delete('images/' . $product->picture);
            Storage::disk('public')->delete('images/resize/' . $product->picture);
        }

        $product->delete();
        return redirect()->route('product.index2')->with('feedback', 'ลบข้อมูลเรียบร้อย');
    }

    public function fetch(Request $request)
    {
        //$address_id =  $request->value;

        $product = Product::where('id', $request->value)->first();

        $output = '<div class="modal-header">
        <h4 class="modal-title">' . $product->name . '</h4>
        </div>
        <div class="modal-body"> 
        <img src="' . asset('../shopping/storage/app/public/images/'. $product->picture) . '" width="200">
        </div>';

        echo $output;
    }
}
